/*                                                                -*-c++-*-
    Copyright (C) 1996-1997 Gregory D. Hager, Kinh Tieu
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
// MPEG library
//
// $RCSfile: MPEG2.hh,v $
// $Revision: 1.1.1.1 $
// $Date: 2001/06/19 14:58:51 $
//
//  4 July 98 Alastair Reid, using
//  10/21/96 Kinh Tieu, (allegedly modeled on IMG_SEQ) using
//           
//                        The MPEG Library
// 
//                  Version 1.2 - 17 October, 1995
// 
// MPEG decoding engine (c) 1992 The Regents of the University of California
// Front end (c) 1994-95 Gregory P. Ward (greg@bic.mni.mcgill.ca)
//
// Copyright (c) 1994-95 by Gregory P. Ward.
// All rights reserved.
// 
// IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT,
// INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
// OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE
// UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
// THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT
// NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER
// IS ON AN "AS IS" BASIS, AND THE AUTHOR HAS NO OBLIGATION TO PROVIDE
// MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.  
//
//-----------------------------------------------------------------------------

#ifndef MPEG2_h
#define MPEG2_h

#include "Image.hh"

extern "C" {
#include "mpeg.h"       // for mpeg lib
}

class MPEG2 
{
private:

  Image vimage;  // store mpeg image frame here
  FILE *mpeg_file;
  ImageDesc img_info;

public:

  MPEG2 (char *fname);
  ~MPEG2() {};
  void close();

  int width()  const { return img_info.Width;  }
  int height() const { return img_info.Height; }

  // Current Image (not a copy - you want a copy, you make it yourself)
  Image& currentImage() { return vimage; }

  // This loads an image and forces the sequence forward by one step.
  void moveForward();
  
};


//-----------------------------------------------------------------------------
#endif
