/*                                                                -*-c++-*-
    Copyright (C) 1996-1997 Gregory D. Hager, Kinh Tieu (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
// MPEG library
//
// $RCSfile: MPEG2.cc,v $
// $Revision: 1.1.1.1 $
// $Date: 2001/06/19 14:58:51 $
//
//  4 July 98 Alastair Reid, using
//  10/21/96 Kinh Tieu, (allegedly modeled on IMG_SEQ) using
//           
//                        The MPEG2 Library
// 
//                  Version 1.2 - 17 October, 1995
// 
// MPEG2 decoding engine (c) 1992 The Regents of the University of California
// Front end (c) 1994-95 Gregory P. Ward (greg@bic.mni.mcgill.ca)
//
// Copyright (c) 1994-95 by Gregory P. Ward.
// All rights reserved.
// 
// IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT,
// INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
// OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE
// UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
// THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT
// NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER
// IS ON AN "AS IS" BASIS, AND THE AUTHOR HAS NO OBLIGATION TO PROVIDE
// MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.  
//
//-----------------------------------------------------------------------------

#include "MPEG2.hh"

#include <stdio.h>

//-----------------------------------------------------------------------------
//  Constructor and destructor
//-----------------------------------------------------------------------------

MPEG2::MPEG2(char *fname) 
{
  if ((mpeg_file = fopen(fname, "rb")) == NULL) { // get mpeg FILE for OpenMPEG
      panic("Can't open MPEG file!");
  }

  SetMPEGOption(MPEG_DITHER, FULL_COLOR_DITHER); // set dither mode
  if (!OpenMPEG(mpeg_file, &img_info)) {  // open mpeg stream
      panic("Couldn't open mpeg file");
  }

  cout << "MPEG2 info:\n";
  cout << "Height = "       << img_info.Height       << endl;
  cout << "Width = "        << img_info.Width        << endl;
  cout << "Depth = "        << img_info.Depth        << endl;
  cout << "PixelSize = "    << img_info.PixelSize    << endl;
  cout << "Size = "         << img_info.Size         << endl;
  cout << "BitmapPad = "    << img_info.BitmapPad    << endl;
  cout << "PictureRate = "  << img_info.PictureRate  << endl;
  cout << "BitRate = "      << img_info.BitRate      << endl;
  cout << "ColormapSize = " << img_info.ColormapSize << endl;
  
  vimage.resize(img_info.Height, img_info.Width);

  moveForward();  // This gets the first frame into vimage
}

void 
MPEG2::close() 
{
  CloseMPEG();  // close mpeg stream
}

//-----------------------------------------------------------------------------
//  Grab functions
//-----------------------------------------------------------------------------

void 
MPEG2::moveForward() 
{
  int size        = img_info.Size;          // in bytes
  int pad_bytes   = img_info.BitmapPad / 8; // bytes for "quantum" of scan line
  int pixel_bytes = img_info.PixelSize / 8; // bytes for each pixel
  int shift_bytes = pixel_bytes - 1;        // max bytes to shift
 
  unsigned char *imbuff = new unsigned char[size];

  // get the next mpeg frame
  if (!GetMPEGFrame((char *) imbuff)) {  // no more frames, rewind and loop
      cout << "rewinding\n";
      if (!RewindMPEG(mpeg_file, &img_info)) {
	  panic("Couldn't rewind mpeg file");
      }
      if (!GetMPEGFrame((char *)imbuff)) {
	  panic("Can't get mpeg frame");
      }
  }

  // store frame into image data
  int *p = vimage.data();

  for (int i = 0; i < size; i += pad_bytes) { // step by scan line quanta
      *p = 0;
      for (int j = 0; j < pixel_bytes; j++) { // fill int with pixel bytes
	  *p += (imbuff[i+j] << ((shift_bytes - j-1) * 8));
      }
      p++;
  }

  delete imbuff;
}

//-----------------------------------------------------------------------------
