/*                                                                -*-c++-*-
    Copyright (C) 1993 Gregory D. Hager and Sidd Puri (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.
*/
//---------------------------------------------------------------------
//*
//* Lists.h
//* 
//* Header file for the Lists template classes
//* There are two List classes : constList and List
//* They are basically linked lists of some element type (elt)
//*
//---------------------------------------------------------------------

#ifndef LISTS_H
#define LISTS_H

#include "Tracker.hh"

template<class elt> class List;
template<class elt> class constList;

/// helper class which holds one data item
template<class elt>
class _Cell
{
  friend class List<elt>;
  elt val;
  _Cell<elt> *next;
  _Cell (elt newelt) { val = newelt; next = 0; }
};

/// helper class which holds one data item
template<class elt>
class _constCell
{
  friend class constList<elt>;
  const elt val;
  _constCell<elt> *next;
  _constCell (elt newelt) : val(newelt) {next = 0; }
};



template<class elt>
class constList
{
protected:

  _constCell<elt> *frt, **end, *cur;
  int nitems;

public:
  constList(); 
  ~constList();

    /// return the number of items in the list
  int n_items();
    /// add a new element "newelt" to the list
  void operator+= (const elt newelt);
    /// remove the nth element from the list
  void operator-= (int n);
    /// deletes the whole list -- used by the destructor
  void kill();
    /// moves the pointer to the "current" element to the front
  void front();
    /// moves the pointer to the "current" element up one
  void operator++();
    /// returns 1 if the "current" element is NULL, 0 if it exists
  _bool operator~();
    /// returns an element (of type elt) currently pointed to
    /// if the current element does not exist, it returns  (elt)(NULL)
  elt operator*();
};



template<class elt>
class List
{
protected:

  _Cell<elt> *frt, **end, *cur;
  int nitems;

public:
  List();
  List(List &l);
  ~List();

    /// leaves the list with no elements
  void clear();
    /// same as n_items()
  int length();
    /// return the number of items in the list
  int n_items();
    /// add a new element "newelt" to the list
  void operator+= (const elt newelt);
    /// remove the nth element from the list
  void operator-= (int n);
    /// deletes the whole list -- used by the destructor
  void kill();
    /// moves the pointer to the "current" element to the front
  void front();
    /// moves the pointer to the "current" element up one
  void operator++();
    /// returns 1 if the "current" element is NULL, 0 if it exists
  _bool operator~();
    /// returns an element (of type elt) currently pointed to
    /// if the current element does not exist, it returns  (elt)(NULL)
  elt operator*();
};


#include "Lists.icc"


#endif

