#ifndef Image_hh
#define Image_hh

#include <string.h>
#include "Tracker.hh"
#include "XVImage.hh"

class Image : public XVImage<int> 
{
  public:

  src_color_scheme color_scheme;

  Image (int ncols_in = 0, int nrows_in = 0) 
    : XVImage<int>(nrows_in, ncols_in)
  {}
  
  Image (const XVImage<int>& im)
    : XVImage<int>(im)
  {}
  
  Image acquire(int x, int y, 
		short int dx, short int dy, short int quadrant,
		int w, int h,
		int sampw, int samph) const;


  operator XVImage<float>() {
    float* floatData = new float[storesize];

    for (int i = 0; i < storesize; i++)
      floatData[i] = (float)image[i];
    XVImage<float> newImage(nrows, ncols, floatData);
    delete floatData;
    return newImage;
  }

};

//----------------------------------------------------------------------------
//  Other useful functions
//----------------------------------------------------------------------------

void Box(Image&,int cen_x,int cen_y,int siz_x,int siz_y);

Image Dx(const Image&);
Image Dy(const Image&);
Image compressx(const Image&);
Image compressy(const Image&);
Image smoothDx(const Image&);
Image smoothDy(const Image&);

Image& Dx(const Image&,Image&);
Image& Dy(const Image&,Image&);
Image& compressx(const Image&,Image&);
Image& compressy(const Image&,Image&);
Image& smoothDx(const Image&,Image&);
Image& smoothDy(const Image&,Image&);

// This are stolen from pipes ...

// get region of image
Image subimage(const Image &im, int lx, int ly, int ux, int uy);

// pixel square root of image
Image sqroot(const Image &im);

// convert RGB image to grayscale
Image grayscale(const Image &im);

// perform an arbitrary projection
Image project(const Image& im,float rc, float gc, float bc, int normalize);


// threshold image, white for below thresh, black above
Image threshold(const Image &im, int thresh, int val = 255);

// convolve image im with image mask
Image convolve(const Image &im, const Image &mask);

// erode image im with image mask
Image erode(const Image &im, const Image &mask);

// x derivative
Image dx(const Image &im);

// y derivative
Image dy(const Image &im);

// sobel edge operator
Image sobel(const Image &im);

//template <class T>
//XVImage<T> variance(const XVImage<T> &,int xsize,int ysize);


//Image variance(const Image &,int xsize,int ysize);




#endif
