/*                                                                -*-c++-*-
    Copyright (C) 1993 Gregory D. Hager and Sidd Puri (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.
*/
//---------------------------------------------------------------------
// Geometry.hh 
// 
// This file contains the structs for 2-D, 3-D, and higher dimensional
// vectors, as well as related typedefs. This file is used by
// FTypes.cc, GILine.cc, and IntersectingLines.cc.
//
//---------------------------------------------------------------------

#ifndef XV_geometry_h
#define XV_geometry_h

#include <math.h>
#include "Tools.hh"

typedef struct {
  float x,y;
} point2D;

typedef struct {
  float x,y,z;
} point3D;

typedef struct {
  float x,y,z,w;
} point4D;

typedef struct {
  float o;
  float d;
} lineAD;

typedef point3D line2D;

inline double distance(point2D a, point2D b) {
  return sqrt(sqr(a.x-b.x)+ sqr(a.y-b.y));
}

#endif


