#include <Pipe.hh>


// The current set of pipeline operators.  Note that the first 
// "id" argument is optional by providing the second definition.
// Note also that for some reason a few of the operators don't
// seem to path the id in --- presumably those which have no
// parameters to modify.  This should be straighted out


// Obvious  +, - and * of two streams

Pipeline operator+(Pipeline &pl1_in, Pipeline &pl2_in);
Pipeline operator*(Pipeline &pl1_in, Pipeline &pl2_in);
Pipeline operator-(Pipeline &pl1_in, Pipeline &pl2_in);

// Square and Square root of the pixel values of an image

Pipeline &PL_Sq(int id_in, Pipeline &pl_in);
inline Pipeline &PL_Sq(Pipeline &pl_in) {return PL_Sq(-1,pl_in);}

Pipeline &PL_Sqrt(int id_in, Pipeline &pl_in);
inline Pipeline &PL_Sqrt(Pipeline &pl_in) {return PL_Sqrt(-1,pl_in);}

// Absolute value of the pixel values of an image

Pipeline &PL_Abs(int id_in, Pipeline &pl_in);
inline Pipeline &PL_Abs(Pipeline &pl_in) {return PL_Abs(-1,pl_in);}

// Average three color channels to a gray-value image scaled
// to 255.

Pipeline &PL_Gray(int id_in, Pipeline &pl_in);
inline Pipeline &PL_Gray(Pipeline &pl_in) {return PL_Gray(-1,pl_in);}

// Project a color image onto a given vector (normalized to be unit).
// Optionally will normalize the input color vectors to be unit.
// Result scaled 0 to 1000.

Pipeline &PL_Project(int id_in, Pipeline &pl_in,
		    float rc, float gc, float bc, int normalize = 0);
inline Pipeline &PL_Project(Pipeline &pl_in,float rc, float gc, float bc, int normalize = 0)
{return PL_Project(-1,pl_in,rc,gc,bc,normalize);}

// Get a subimage of the original image

Pipeline &PL_Subimage(int id_in, Pipeline &pl_in, int lx_in, int ly_in, 
		     int ux_in, int uy_in);
inline Pipeline &PL_Subimage(Pipeline &pl_in, int lx_in, int ly_in, 
			    int ux_in, int uy_in) 
{return PL_Subimage(-1, pl_in, lx_in, ly_in, ux_in, uy_in);}

// Threshold --- values below threshold to zero; values above
// to the given value which defaults to 255

Pipeline &PL_Threshold(int id_in, Pipeline &pl_in, int thresh_in, int val_in = 255);
inline Pipeline &PL_Threshold(Pipeline &pl_in, int thresh_in, int val_in = 255) 
                     {return PL_Threshold(-1,pl_in, thresh_in, val_in);}

// Delay the image by one count

Pipeline &PL_Delay(int id_in, Pipeline &pl_in);
inline Pipeline &PL_Delay(Pipeline &pl_in) {return PL_Delay(-1,pl_in);}

// Gaussian filter with given width and sigma values -- as with all
// convolutions here, it zero-pads the outside of the result where
// there are no useful values

Pipeline &PL_Gaussian(int id_in, Pipeline &pl_in, 
		     int width_in, double sigmax_in,
		     int height_in = -1, double sigmay_in = -1);
inline Pipeline &PL_Gaussian(Pipeline &pl_in, 
		     int width_in, double sigmax_in,
		     int height_in = -1, double sigmay_in = -1) {
  return PL_Gaussian(-1,pl_in, width_in, sigmax_in,height_in,sigmay_in);}

// General convolution by a mask

Pipeline &PL_Convolve(int id_in, Pipeline &pl_in, const Image &mask);
inline Pipeline &PL_Convolve(Pipeline &pl_in, const Image &mask) 
               {return PL_Convolve(-1,pl_in, mask);}

// Perform erosion by oring with the negation of the given mask

Pipeline &PL_Erode(int id_in, Pipeline &pl_in, const Image &mask);
inline Pipeline &PL_Erode(Pipeline &pl_in, const Image &mask) 
{return PL_Erode(-1,pl_in, mask);}

// Does a Laplacian of a Gaussian --- never tested by GDH

Pipeline &PL_Laplacian_Gaussian(int id_in, Pipeline &pl_in, int width_in, double sigma_in);
inline Pipeline &PL_Laplacian_Gaussian(Pipeline &pl_in, int width_in, double sigma_in) 
{return PL_Laplacian_Gaussian(-1,pl_in, width_in, sigma_in);}

// Prewitt derivative x

Pipeline &PL_Dx(int id_in, Pipeline &pl_in);
inline Pipeline &PL_Dx(Pipeline &pl_in) {return PL_Dx(-1,pl_in);}

// Prewitt derivative y

Pipeline &PL_Dy(int id_in, Pipeline &pl_in);
inline Pipeline &PL_Dy(Pipeline &pl_in) {return PL_Dy(-1,pl_in);}

// Sobel operator

Pipeline &PL_Sobel(int id_in, Pipeline &pl_in);
inline Pipeline &PL_Sobel(Pipeline &pl_in) {return PL_Sobel(-1,pl_in);}

// Reduce resolution

Pipeline &PL_Reduce(int id_in, Pipeline &pl_in,int factor);
inline Pipeline &PL_Reduce(Pipeline &pl_in,int factor) {return PL_Reduce(-1,pl_in,factor);}


Pipeline &PL_Convtrack(int id_in, Pipeline &pl_in, int lx_in, int ly_in, 
		      int ux_in, int uy_in, int trans_in);
