#include <Pipeline.hh>

Pipeline operator+(Pipeline &pl1_in, Pipeline &pl2_in)
{
  Pipe *p_new = new Pipe_Plus(pl1_in.get_last(),pl2_in.get_last());
  Pipeline pl_new = pl1_in;

  for (int i=0; i<pl2_in.get_num_pipes(); i++)
    pl_new.add_pipe(pl2_in.get_pipe(i));

  pl_new.add_pipe(p_new);

  return pl_new;
}

Pipeline operator-(Pipeline &pl1_in, Pipeline &pl2_in)
{
  Pipe *p_new = new Pipe_Minus(pl1_in.get_last(),pl2_in.get_last());
  Pipeline pl_new = pl1_in;

  for (int i=0; i<pl2_in.get_num_pipes(); i++)
    pl_new.add_pipe(pl2_in.get_pipe(i));

  pl_new.add_pipe(p_new);

  return pl_new;
}

Pipeline operator*(Pipeline &pl1_in, Pipeline &pl2_in)
{
  Pipe *p_new = new Pipe_Mult(pl1_in.get_last(),pl2_in.get_last());
  Pipeline pl_new = pl1_in;

  for (int i=0; i<pl2_in.get_num_pipes(); i++)
    pl_new.add_pipe(pl2_in.get_pipe(i));

  pl_new.add_pipe(p_new);

  return pl_new;
}

Pipeline &PL_Sq(int id_in, Pipeline &pl_in)
{
  Pipe *p_new = new Pipe_Sq(pl_in.get_last());
  Pipeline *pl_new = new Pipeline(pl_in);

  pl_new->add_pipe(p_new);

  return *pl_new;
}

Pipeline &PL_Abs(int id_in, Pipeline &pl_in)
{
  Pipe *p_new = new Pipe_Abs(pl_in.get_last());
  Pipeline *pl_new = new Pipeline(pl_in);

  pl_new->add_pipe(p_new);

  return *pl_new;
}

Pipeline &PL_Gray(int id_in, Pipeline &pl_in)
{
  Pipe *p_new = new Pipe_Gray(pl_in.get_last());
  Pipeline *pl_new = new Pipeline(pl_in);

  pl_new->add_pipe(p_new);

  return *pl_new;
}

Pipeline &PL_Sqrt(int id_in, Pipeline &pl_in)
{
  Pipe *p_new = new Pipe_Sqrt(pl_in.get_last());
  Pipeline *pl_new = new Pipeline(pl_in);

  pl_new->add_pipe(p_new);

  return *pl_new;
}

Pipeline &PL_Subimage(int id_in, Pipeline &pl_in, int lx_in, int ly_in, 
		     int ux_in, int uy_in)
{
  Pipe *p_new = new Pipe_Subimage(id_in,pl_in.get_last(),lx_in,ly_in,ux_in,
				  uy_in);
  Pipeline *pl_new = new Pipeline(pl_in);
 
  pl_new->add_pipe(p_new);

  return *pl_new;
}

Pipeline &PL_Delay(int id_in, Pipeline &pl_in)
{
  Pipe *p_new = new Pipe_Delay(pl_in.get_last());
  Pipeline *pl_new = new Pipeline(pl_in);

  pl_new->add_pipe(p_new);

  return *pl_new;
}

Pipeline &PL_Threshold(int id_in, Pipeline &pl_in, int thresh_in, int val_in)
{
  Pipe *p_new = new Pipe_Threshold(id_in,pl_in.get_last(),thresh_in, val_in);
  Pipeline *pl_new = new Pipeline(pl_in);

  pl_new->add_pipe(p_new);

  return *pl_new;
}

Pipeline &PL_Dx(int id_in, Pipeline &pl_in)
{
  Pipe *p_new = new Pipe_Dx(pl_in.get_last());
  Pipeline *pl_new = new Pipeline(pl_in);

  pl_new->add_pipe(p_new);

  return *pl_new;
}

Pipeline &PL_Dy(int id_in, Pipeline &pl_in)
{
  Pipe *p_new = new Pipe_Dy(pl_in.get_last());
  Pipeline *pl_new = new Pipeline(pl_in);

  pl_new->add_pipe(p_new);

  return *pl_new;
}

Pipeline &PL_Sobel(int id_in, Pipeline &pl_in)
{
  Pipe *p_new = new Pipe_Sobel(pl_in.get_last());
  Pipeline *pl_new = new Pipeline(pl_in);

  pl_new->add_pipe(p_new);

  return *pl_new;
}

Pipeline &PL_Gaussian(int id_in, Pipeline &pl_in, 
		     int width_in, double sigmax_in,
		     int height_in, double sigmay_in)
{

  if (height_in < 0) height_in = width_in;
  if (sigmay_in < 0) sigmay_in = sigmax_in;

  Pipe *p_new = new Pipe_Gaussian(id_in,pl_in.get_last(),width_in, sigmax_in,
				  height_in, sigmay_in);
  Pipeline *pl_new = new Pipeline(pl_in);

  pl_new->add_pipe(p_new);

  return *pl_new;
}

Pipeline &PL_Convolve(int id_in, Pipeline &pl_in, const Image &mask)
{
  Pipe *p_new = new Pipe_Convolve(id_in,pl_in.get_last(),mask);
  Pipeline *pl_new = new Pipeline(pl_in);

  pl_new->add_pipe(p_new);

  return *pl_new;
}

Pipeline &PL_Erode(int id_in, Pipeline &pl_in, const Image &mask)
{
  Pipe *p_new = new Pipe_Erode(id_in,pl_in.get_last(),mask);
  Pipeline *pl_new = new Pipeline(pl_in);

  pl_new->add_pipe(p_new);

  return *pl_new;
}
/*
Pipeline PL_Variance(int id_in, Pipeline &pl_in, int height_in, int width_in)
{
  Pipe *p_new = new Pipe_Variance(id_in,pl_in.get_last(),height_in, width_in);
  Pipeline pl_new = pl_in;

  pl_new.add_pipe(p_new);

  return pl_new;
}
*/
Pipeline &PL_Laplacian_Gaussian(int id_in, Pipeline &pl_in, int width_in, 
			       double sigma_in)
{
  Pipe *p_new = new Pipe_Laplacian_Gaussian(id_in,pl_in.get_last(),width_in,
					    sigma_in);
  Pipeline *pl_new = new Pipeline(pl_in);

  pl_new->add_pipe(p_new);

  return *pl_new;
}

Pipeline &PL_Reduce(int id_in, Pipeline &pl_in, int factor)
{
  Pipe *p_new = new Pipe_Reduce(id_in,pl_in.get_last(),factor);
  Pipeline *pl_new = new Pipeline(pl_in);

  pl_new->add_pipe(p_new);

  return *pl_new;
}

Pipeline &PL_Project(int id_in, Pipeline &pl_in, 
		   float rc, float gc, float bc, int normalize)
{
  Pipe *p_new = new Pipe_Project(id_in,pl_in.get_last(),rc,gc,bc,normalize);
  Pipeline *pl_new = new Pipeline(pl_in);

  pl_new->add_pipe(p_new);

  return *pl_new;
}

Pipeline &PL_Convtrack(int id_in, Pipeline &pl_in, int lx_in, int ly_in, 
		      int ux_in, int uy_in, int trans_in)
{
  Pipe *p_new = new Pipe_Convtrack(id_in,pl_in.get_last(),lx_in,ly_in,ux_in,
				   uy_in, trans_in);
  Pipeline *pl_new = new Pipeline(pl_in);

  pl_new->add_pipe(p_new);

  return *pl_new;
}
