#include <Image.hh>


// get region of image
Image subimage(const Image &im, int lx, int ly, int ux, int uy);

// pixel square root of image
Image sqroot(const Image &im);

// convert RGB image to grayscale
Image grayscale(const Image &im);

// perform an arbitrary projection
Image project(const Image& im,float rc, float gc, float bc, int normalize);

// threshold image, white for below thresh, black above
Image threshold(const Image &im, int thresh, int val = 255);

// convolve image im with image mask
Image convolve(const Image &im, const Image &mask);

// erode image im with image mask
Image erode(const Image &im, const Image &mask);

// x derivative
Image dx(const Image &im);

// y derivative
Image dy(const Image &im);

// sobel edge operator
Image sobel(const Image &im);

//template <class T>
//XVImage<T> variance(const XVImage<T> &,int xsize,int ysize);


//Image variance(const Image &,int xsize,int ysize);
