/*                                                                -*-c++-*-
    Copyright (C) 1994 Gregory D. Hager (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  typeinfo.hh
//
//  Simple type class.  Keeps a unique representation of the object
//  and a casting pointer.
//
//  8/1/94
//  Gregory D. Hager
//
//-----------------------------------------------------------------------------
#ifndef _typeinfo_h
#define _typeinfo_h 1

class _typeinfo
{
  const char *name;
  const void *cast_ptr;

public:
  
  _typeinfo(const char *n,void *c) : name(n), cast_ptr(c) {};
  const void *cast_from() const {return cast_ptr;};
  int operator == (const char *c) const {return name == c;};
};


#endif
