#include "rate.hh"
#include <stdio.h>

TimingInfo::TimingInfo(int interv, int doprinting, char* name)
{
  interval = interv;
  count = 0;
  therate = 0.0f;
  sprintf(namebuf, "%s", name);
  doprint = doprinting;
};
TimingInfo::TimingInfo(const TimingInfo& t)
{
  interval = t.interval;
  count = t.count;
  therate = t.therate;
  sprintf(namebuf, "%s", t.namebuf);
  doprint = t.doprint;
};
void TimingInfo::tick()
{
  if (interval > 0)
    { 
      count++;
      count %= interval;
      if (!(count))
	{
	  timeval newt;
	  
	  gettimeofday(&newt,NULL);
	  // calculate time elapsed in seconds
	  int dsec = newt.tv_sec - oldt.tv_sec;	  
	  // calculate time elapsed in microseconds	  
	  int dusec = newt.tv_usec - oldt.tv_usec;
	  
	  // convert time elapsed to milliseconds
	  double msecs = 
	    ((double)dsec  * 1000) + 
	    ((double)dusec / 1000);
	  
	  
	  // this gets average time per frame (in msecs)	 
	  msecs /= interval;  
	  // stores state information about time	  
	  oldt = newt;			 
	  // computes Hz	  
	  therate = 1000.0/msecs;
	  
	  if (doprint)
	    printf("%s rate report: %4.3f Hz \n", namebuf, therate);
	};
    };
};

