#ifndef RATE_H
#define RATE_H


#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
//#include <timebits.h>


class TimingInfo {
public:
  TimingInfo(int interv, int doprinting = 0, char* name = "unknown");
  TimingInfo(const TimingInfo& t);
  void tick();
  void start();
  void setinterval(int interv) {interval = interv;};
  void setprinting(int dop)    {doprint = dop;};
  float rate() {return therate;};
  
  // Use as a polled alarm

  void set_deadline_next(float delta_t) {deadline += delta_t;};
  void set_deadline(float delta_t) {start();deadline =  delta_t;};
  int   alarm(int reset = 0);

private:	
  char namebuf[256];
  int doprint;
  int count;
  float therate;
  int interval;
  timeval oldt;
  timeval alarmt;
  float msecs;
  float deadline;
};

inline int TimingInfo::alarm(int reset)
{
  timeval temp;
  gettimeofday(&temp,NULL);
  int retval = (((temp.tv_sec-alarmt.tv_sec)*1000.0 + 
		 (temp.tv_usec - alarmt.tv_usec)/1000.0 ) >= deadline);
  if (retval) {
    if (reset)
      alarmt = temp;
  }
  return retval;
}

#endif

