/*                                                                -*-c++-*-
    Copyright (C) 1993 Gregory D. Hager and Sidd Puri (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  Tracker.hh
//
//  Globally useful definitions for tracker system.
//
//  6 - 6 - 93
//  Sidd Puri
//
//-----------------------------------------------------------------------------
#ifdef NO_TEMPLATES
#include "Trackerwotemp.hh"
#else

#ifndef Tracker_h
#define Tracker_h


#ifdef __GNUC__
// egcs cant find this include file 
// #include <std.h>
#endif


#include <iostream.h>
#include <math.h>

// unneeded
// #include <new.h>

#include <stdlib.h>
#include <site_config.h>

//-----------------------------------------------------------------------------
//  Enumerations
//-----------------------------------------------------------------------------

typedef enum { stupid_FALSE = 0, stupid_TRUE = 1 } stupid_bool_val; 
#define _bool stupid_bool_val

enum FeatureType {Basic,Composite,Extension};


//-----------------------------------------------------------------------------
//  Constants
//-----------------------------------------------------------------------------

#ifndef M_PI
float const M_PI = 3.1415927;
#endif
#ifndef M_PI_2
float const M_PI_2 = M_PI/2.0;
#endif
#ifndef twopi
float const twopi = (2.0 * M_PI);
#endif
#ifndef M_2_PI
float const M_2_PI = twopi;
#endif
#ifndef TINY
float const TINY = 0.001;          // Smallest denominator value
#endif


// color definitions
#include "XVColors.hh"



//-----------------------------------------------------------------------------
//  Class declarations
//-----------------------------------------------------------------------------

class CWindow;
class Video;
class BasicFeature;
class CompFeature;
class FeatureExtension;
class BaseType;
class Image;

//-----------------------------------------------------------------------------
//  General global variables and functions
//-----------------------------------------------------------------------------

void panic (char *error = "", stupid_bool_val syserr = stupid_TRUE);


//-----------------------------------------------------------------------------
//  Initialization and cleanup structures
//-----------------------------------------------------------------------------

void tracker_init();
void tracker_cleanup (Video *v);
void tracker_cleanup (CWindow *c);
void tracker_cleanup (void (*f)());
#ifdef __SC__
extern "C" void tracker_do_cleanup();
#else
#ifdef ATT_CC
void tracker_do_cleanup();
#else
#ifdef __GNUG__
void tracker_do_cleanup(int);
#else
void tracker_do_cleanup(int);
#endif
#endif
#endif

//-----------------------------------------------------------------------------
#endif
#endif
