/*
    Copyright (C) 1991 Gregory D. Hager and Sidd Puri (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*///-----------------------------------------------------------------------------
//
//  Tracker.cc
//
//  Definition of tracker initialization and cleanup functions.
//
//  7 - 2 - 93
//  Sidd Puri
//
//-----------------------------------------------------------------------------

#include <signal.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <site_config.h>
#include "Tracker.hh"
#include "Video.hh"
#include "CWindow.hh"

//-----------------------------------------------------------------------------
//  Definition Global variables
//-----------------------------------------------------------------------------

int const MAX_THINGS = 100;

extern struct cleanup_structure {
  int nvid;
  Video *v[MAX_THINGS];
  int ncons;
  CWindow *c[MAX_THINGS];
  int nfunct;
  void (*f[MAX_THINGS])();
} tracker_cleanup_structure;

cleanup_structure tracker_cleanup_structure;
stupid_bool_val tracker_init_done = stupid_FALSE;

//-----------------------------------------------------------------------------
//  Initialization and cleanup functions
//-----------------------------------------------------------------------------

void tracker_init() {
  if (tracker_init_done) return;
  memset(&tracker_cleanup_structure,0,sizeof(cleanup_structure));
#if (XV_OS == XV_IRIX)
  signal (SIGINT, (SIG_PF)tracker_do_cleanup);
#else
  signal (SIGINT, tracker_do_cleanup);
#endif
  tracker_init_done = stupid_TRUE;
}

void tracker_cleanup (Video *v) {
  if (tracker_cleanup_structure.nvid > MAX_THINGS)
    panic("Too many Video devices \n");
  tracker_init();
  tracker_cleanup_structure.v[tracker_cleanup_structure.nvid++] = v;
}

void tracker_cleanup (CWindow *c) {
  if (tracker_cleanup_structure.ncons > MAX_THINGS)
    panic("Too many Windows \n");
  tracker_init();
  tracker_cleanup_structure.c[tracker_cleanup_structure.ncons++] = c;
}

void tracker_cleanup (void (*f)()) {
  if (tracker_cleanup_structure.nfunct > MAX_THINGS)
    panic("Too many exit functions \n");
  tracker_init();
  tracker_cleanup_structure.f[tracker_cleanup_structure.nfunct++] = f;
}

#ifdef __SC__
extern "C" {
#endif

void tracker_do_cleanup(
#ifdef __GNUG__
int
#else
int
#endif
) {
  int i;
  i = 0;
  while (tracker_cleanup_structure.v[i] != NULL)
    tracker_cleanup_structure.v[i++]->close();
  i = 0;
  while (tracker_cleanup_structure.c[i] != NULL)
    tracker_cleanup_structure.c[i++]->close();
  i = 0;
  while (tracker_cleanup_structure.f[i] != NULL)
    (*tracker_cleanup_structure.f[i++])();
  
  exit (0);
}

#ifdef __SC__
}
#endif

//-----------------------------------------------------------------------------


void panic (char *error, stupid_bool_val syserr) {
  if (syserr) perror (error);
  else cerr << error;
  cerr << endl;
  tracker_do_cleanup(
#ifdef __GNUG__
0
#else
0
#endif
);
}

void panic (char *error) {panic(error,stupid_TRUE);};

//-----------------------------------------------------------------------------

