/*
    Copyright (C) 1993 Gregory D. Hager and Sidd Puri (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  FeatureGroup.hh
//
//  Declaration of FeatureGroup class.  A FeatureGroup is an inactive
//  expadable aggregate.
//
//  7 - 31 - 94
//  Greg Hager (rewrote in modified form from original by Sidd Puri).
//-----------------------------------------------------------------------------

#ifndef FeatureGroup_h
#define FeatureGroup_h

#include "BasicFeature.hh"
#include "Lists.hh"
#include "BaseType.hh"

//-----------------------------------------------------------------------------
//  FeatureGroup class declaration
//-----------------------------------------------------------------------------

class FeatureGroup: public BasicFeature {
friend class CompFeature;

  constList<BasicFeature *> children;
  int recursive_update;   // Perform update on descendents.

protected:

  const BasicFeature *child(int n) 
    { int i; children.front(); 
      for (i=0; i<n;i++,++children); return (*children); 
    };

public:

  // Constructors and Destructors

  FeatureGroup (int pncoords_in = 0, const char *name = "FeatureGroup",
		Color color_in = no_color);
  FeatureGroup (FeatureGroup &p);
  virtual ~FeatureGroup();

  // Toggles

  int &do_recursive_update() {return recursive_update;};

  // The duplication function

  virtual BasicFeature *dup() {return new FeatureGroup (*this); };

  // BasicFeature required functions

  virtual int show (Color color_in = no_color);
  virtual int clear ();
  virtual int update ();
  virtual int compute_state () {return 1;};

  // Basic tracking cycle for this type of feature
  virtual int track() {
    int res;
    if (copy_to_update) {
      BasicFeature *temp = dup();
      res = update();
      temp->clear();
      show();
      delete temp;
    }
    else {
      replicate_forward();
      res=update();
      erase_last();
      show();
    }
    if (is_top_level())
      {
	tinfo.tick();
      };
    return res;
  }

  // Adding to the group 

  BasicFeature *operator+= (BasicFeature *newBasicFeature);
  BasicFeature *operator+= (BaseType *newBasicFeature) {
    return(*this += (BasicFeature *)(*newBasicFeature));
  }
  BasicFeature *operator+= (BasicFeature &newBasicFeature) {
    return(*this += newBasicFeature.dup());
  }

  // For displaying if appropriate

  void set_display(Video *vin) { v = vin;};

};

//-----------------------------------------------------------------------------
#endif

