/*
    Copyright (C) 1994 Gregory D. Hager (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  FeatureGroup.cc
//
//  Definition of FeatureGroup member functions.
//
//  8 - 1 - 94
//  Gregory D. Hager
//
//-----------------------------------------------------------------------------

#include "FeatureGroup.hh"

//-----------------------------------------------------------------------------
//  Constructors and destructor
//-----------------------------------------------------------------------------

FeatureGroup::FeatureGroup (int ncoords_in, const char *name, Color color_in):
       BasicFeature (ncoords_in, NULL, name, color_in) 
{
  recursive_update = 0;
  featuretype = Extension;
}

FeatureGroup::FeatureGroup (FeatureGroup &p) : BasicFeature(p) {
  recursive_update = p.recursive_update;
  featuretype  = Extension;

  for (p.children.front(); !~p.children; ++(p.children))
    *this +=((*p.children)->dup());

}

FeatureGroup::~FeatureGroup() {
  children.kill();
}

//-----------------------------------------------------------------------------
//  BasicFeature member functions
//-----------------------------------------------------------------------------

int FeatureGroup::show (Color color_in) {
  int res = 1;
  for (children.front(); !~children; ++children)
    res &= (*children)->show (color_in);
  return res;
}

int FeatureGroup::clear () {
  int res = 1;
  for (children.front(); !~children; ++children)
    res &= (*children)->clear ();
  return res;
}

int FeatureGroup::update () {
  int res = 1;

  // Check to see if children get updated

  if (recursive_update) 
    for (children.front(); !~children; ++children) {
	res &= (*children)->update();
  }
  // Compute the local state

  res &= compute_state();

  return res;
}

//-----------------------------------------------------------------------------
//  FeatureGroup member functions
//-----------------------------------------------------------------------------

BasicFeature *FeatureGroup::operator+= (BasicFeature *t) {
  children +=t;
  return t;
}

//-----------------------------------------------------------------------------
