/*                                                                -*-c++-*-
    Copyright (C) 1993 Gregory D. Hager and Sidd Puri (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  CompFeature.hh
//
//  Declaration of CompFeature class expandable aggregate of actively
//  managed children.
//
//  7 - 31 -94
//  Greg Hager (rewrote in modified form from original version by Sidd Puri).
//-----------------------------------------------------------------------------

#ifndef CompFeature_h
#define CompFeature_h

#include "FeatureGroup.hh"

// For backwards compatibility with earlier versions

#define Polything CompFeature

//-----------------------------------------------------------------------------
//  CompFeature class declaration
//-----------------------------------------------------------------------------

class BaseType;

class CompFeature: public FeatureGroup {


protected:


  virtual void replicate_forward() {
    BasicFeature::replicate_forward();
    for (children.front(); !~children; ++children) {
      (*children)->replicate_forward ();
    }
  }

  virtual void back() {
    BasicFeature::back();
    for (children.front(); !~children; ++children) 
	(*children)->back();
  }

  virtual void forward() {
    BasicFeature::forward();
    for (children.front(); !~children; ++children)
	(*children)->forward();
  }

public:

  // Constructors and Destructors

  CompFeature (int pncoords_in = 0, const char *name = "CompFeature",
	       Color color_in = no_color);
  CompFeature (CompFeature &p);
  virtual ~CompFeature();

  // Initialization options

  virtual int state_init(float *state_in);
  virtual int interactive_init (CWindow &w);

  // Access any of the childs

  const BasicFeature *child(int n) {return (const BasicFeature *)FeatureGroup::child(n);};

  // The duplication function (this must appear in all classes that
  // have any sort of local storage.

//  virtual BasicFeature *dup() {return FeatureGroup::dup();};
  virtual BasicFeature *dup() {return new CompFeature(*this);};

  // BasicFeature required functions

  virtual int show (Color color_in = no_color);
  virtual int clear ();
  virtual int update ();

  // Additional FeatureGroup required functions

  virtual int compute_state ();

  // Additional CompFeature functions

  virtual int constraints ();
  virtual int propagate ();

  // Basic tracking cycle for this type of feature

  virtual int track() {
    int res;
    if (copy_to_update) {
      BasicFeature *temp = dup();
      res = state_update();
      temp->clear();
      show();
      delete temp;
    }
    else { // usually comes in here
      replicate_forward();
      res = state_update();
      erase_last();
      show();
    }      
    if (is_top_level()) 
      {
	tinfo.tick();
      };       
    return res;
  }

  void erase_last() { back(); clear(); forward(); }

  BasicFeature *operator+= (BasicFeature &newBasicFeature);
  void operator-= (int n) {
    children -= n;
  }


#ifdef NEW_VERS
  BasicFeature *operator+= (BasicFeature *newBasicFeature);
#endif
//  CompFeature &operator+= (BaseType &newBasicFeature);

};

//-----------------------------------------------------------------------------
#endif
