/*
    Copyright (C) 1991 Gregory D. Hager  (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  CompFeature.cc
//
//  Definition of CompFeature member functions.
//
//  8 - 1 - 94
//  Gregory D. Hager from original version by Sidd Puri
//
//-----------------------------------------------------------------------------

#include "CompFeature.hh"

//-----------------------------------------------------------------------------
//  Constructors and destructor
//-----------------------------------------------------------------------------

CompFeature::CompFeature (int ncoords_in, const char *name, Color color_in):
       FeatureGroup (ncoords_in, name, color_in) 
{
  featuretype = Composite;
}

CompFeature::CompFeature (CompFeature &p) : FeatureGroup(p) {}

CompFeature::~CompFeature() {
  for (children.front(); !~children; ++children)
    delete *children;
}

//-----------------------------------------------------------------------------
//  BasicFeature member functions
//-----------------------------------------------------------------------------

int CompFeature::state_init (float *state_in) {
  if (ncoords == 0)
    panic("Cannot use state initialization of trival CompFeature");
  
  memcpy(state,state_in,sizeof(float)*ncoords);
  return propagate();

}

int CompFeature::interactive_init (CWindow &w) {
  int res = 1;
  for (children.front(); !~children; ++children) {
      res &= (*children)->interactive_init (w);
  }
  return res;
}

int CompFeature::show (Color color_in) {
  int res = 1;
  color_in = map_color(color_in);
  for (children.front(); !~children; ++children)
    res &= (*children)->show (color_in);
  return res;
}

int CompFeature::clear () {
  int res = 1;
  for (children.front(); !~children; ++children) {
    res &= (*children)->clear ();
  }
  return res;
}

int CompFeature::constraints(){return 1;};
int CompFeature::compute_state() {return 1;};

int CompFeature::propagate() {
  int res =   constraints();
  for (children.front(); !~children; ++children)
    res &= (*children)->propagate ();
  return res;
}

int CompFeature::update () {
  int res = 1;
  for (children.front(); !~children; ++children) {
    res &= (*children)->state_update ();
  }
  if (res != 1) // lost track
	{ return res; }

  res &= compute_state();
  if (res != 1)
	{ return res;}

  if (is_top_level())
    res &=propagate();

  return res;
}

//-----------------------------------------------------------------------------
//  CompFeature member functions
//-----------------------------------------------------------------------------

BasicFeature *CompFeature::operator+= (BasicFeature &t) {

  if (!(t.is_top_level()))
    panic("Attempt to add non-top-level feature to CompFeature");
  if (!(t.modifiable()))
    panic("Attempt to add non-modifiable feature to CompFeature");
  BasicFeature *temp = t.dup();
  temp->set_nontop();
  return FeatureGroup::operator+=(temp);

}
#ifdef NEW_VERS
BasicFeature *CompFeature::operator+= (BasicFeature *t) {

  if (!(t->is_top_level()))
    panic("Attempt to add non-top-level feature to CompFeature");
  if (!(t->modifiable()))
    panic("Attempt to add non-modifiable feature to CompFeature");
  t->set_nontop();
  return FeatureGroup::operator+=(t);

}
#endif
/*
CompFeature &CompFeature::operator+=(BaseType &t) {
  if (!(t->is_top_level()))
    panic("Attempt to add non-top-level feature to CompFeature");
  BasicFeature *temp = t->dup();
  temp->set_nontop();
  FeatureGroup::operator+=(temp);
  return *this;
}  
*/
//-----------------------------------------------------------------------------
