/*                                                                -*-c++-*-
    Copyright (C) 1993 Gregory D. Hager and Sidd Puri (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
/* This is a feature group which computes the position of intersection
 * of two lines.
 *
 * G. Hager  5/13/93
 */

#ifndef IntersectingLines_H
#define IntersectingLines_H

#include <math.h>
#include "Line.hh"
#include "CompFeature.hh"

extern "C" void sincos(double,double *,double *);


//======================== IntersectingLines Class =========================



class IntersectingLines : public FeatureGroup, public PointFeature
{

  const LineFeature *line1, *line2;   // For convenience.

protected:

  const LineFeature *lchild(int n) 
    {return const_ptr_cast(LineFeature,child(n));};

public:

  float set_x(float xin)  {return state[0] = xin;}
  float set_y(float yin)  {return state[1] = yin;}

  // just for backward compatible
  float x(float xin)      {return state[0] = xin;}
  float y(float yin)      {return state[1] = yin;}

  IntersectingLines(LineFeature *l1, LineFeature *l2, 
		    Color color_in = default_color);

  IntersectingLines(IntersectingLines &g) : FeatureGroup(g), 
                                            PointFeature(this) 
  {
    line1 = lchild(0);
    line2 = lchild(1);
  }

  virtual Thing *dup() {return new IntersectingLines (*this); };

  float x() const {return state[0];};
  float y() const {return state[1];};

  const LineFeature &Line1() {return *line1;};
  const LineFeature &Line2() {return *line2;};

  int compute_state();

};

#endif
