/*
    Copyright (C) 1991 Gregory D. Hager and Sidd Puri (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  IntersectingLines.cc
//
//  Definition of IntersectingLines member functions.
//
//  9 - 1 - 93
//  Greg Hager
//
//-----------------------------------------------------------------------------


#include "IntersectingLines.hh"

IntersectingLines::IntersectingLines(LineFeature *l1, LineFeature *l2,
				     Color color_in) : 
	       FeatureGroup(2,"IntersectingLines",color_in), 
	       PointFeature(this)
    {

      (*this) += l1;
      (*this) += l2;

      line1 = lchild(0);
      line2 = lchild(1);
      
    }

int IntersectingLines::compute_state()
{
  line2D l1 = line1->coordinates();
  line2D l2 = line2->coordinates();

  float den = l1.x * l2.y - l2.x * l1.y;

  if (fabs(den) < TINY) return 0;

  state[0] = -(l2.y * l1.z - l1.y * l2.z)/den;
  state[1] = (l2.x * l1.z - l1.x * l2.z)/den;

  return 1;
}

