/*
 *	
 */

#include	<stdio.h>
//#include        <stdlib.h>
//#include        <fstream.h>
#include	<sys/fcntl.h>
#include	<sys/types.h>
#include	<sys/file.h>
#include	<sys/mman.h>
#include	<sys/sfvmereg.h>
#include	"sfvmelib.h"


#define	PRINTINTERVAL	2

extern	int	errno;

int
sfvme_open(char *dev)
{
	int	vme_fd;

	vme_fd = open(dev, O_RDWR);
	if (vme_fd == -1) {
		printf("*** Couldn't open %s, errno = %d\n",
			 dev, errno);
		exit(0);
	}
	printf("[Opened %s]\n", dev);
	return (vme_fd);
}	/* end of sfvme_open */

/*
 * Move the VME window so that it maps the requested
 * VME physical address "vme_paddr".
 */
void
sfvme_vmapset(int fd, int vme_paddr)
{
	printf("[Window set to VME addr: 0x%x]\n", vme_paddr);
	if (ioctl(fd, SFVME_SET, &vme_paddr) == -1)
		printf("sfvme_vmapset: errno = %d\n", errno);
}	/* end of sfvme_vmapset */

/*
 * Get the VME physical address that the VME window points to.
 */
int
sfvme_vmapget(int fd, int doprint)
{
	int	vme_paddr;

	if (ioctl(fd, SFVME_GET, &vme_paddr) == -1)
		printf("sfvme_vmapget: errno = %d\n", errno);
	if (doprint)
		printf("vme address = 0x%x\n", vme_paddr);
	return (vme_paddr);
}	/* end of sfvme_vmapget */

/*
 * Map a portion of VME physical memory into the
 * program's address space.
 * Returns: the virtual address of the newly mapped
 *          VME physical memory.
 */

int *
sfvme_mmap(int fd, int len, int vme_addr)
{
	int	addr;
	int	pg_addr;
	int	pg_off;

	pg_addr = vme_addr & 0xfffff000;
	pg_off = vme_addr & 0xfff;
	len = len + 0xfff;
	len = len & 0xfffff000;
	addr = (int)mmap(0, len, PROT_READ|PROT_WRITE, MAP_SHARED, fd, pg_addr);
	addr = addr | pg_off;
	if (addr == -1) {
		printf("sfvme_mmap: errno = %d\n", errno);
		printf("mapping error\n");
		exit(1);
	}
		printf("sfvme_mmap set at = 0x%x\n", pg_addr);
	return ((int *)addr);
}	/* end of sfvme_mmap */

typedef struct sbusmapping {
	struct sbusmapping	*sbus_next;
	u_int	sbus_offset;
	u_int	sbus_size;
	int *	sbus_vaddr;
} sbusmapping_t;

sbusmapping_t	*sbusmaps = NULL;

int *
sbus_mapsearch(u_int	sbus_off, u_int	sbus_sz)
{
	sbusmapping_t	*s;

	for (s = sbusmaps; s != NULL; s = s->sbus_next) {
		if (sbus_off == s->sbus_offset) {
			if (sbus_sz <= s->sbus_size) {
				return (s->sbus_vaddr);
			}
		}
	}
	return (NULL);
}

int *
sfvme_needmmap(int fd, int vme_size, int vme_paddr) {
	u_int	new_sbus_off;
	u_int	new_sbus_size;
	int *	vaddr;

	new_sbus_off = vme_paddr & 0x07ffffff;
	new_sbus_size = vme_size;
	/*
	 * The next two statements ensure that the size
	 * is aligned to a multiple of the MMU page size.
	 * (The system call mmap() will return an error
	 * condition unless this is true.)
	 */
	new_sbus_size = new_sbus_size + 0xfff;
	new_sbus_size = new_sbus_size & 0xfffff000;
	if (sbusmaps != NULL) {
		vaddr = sbus_mapsearch(new_sbus_off, new_sbus_size);
		if (vaddr == NULL) {
			sbusmapping_t	*s;

			printf("[Doing mmap for VME: 0x%x size 0x%x]\n",
					vme_paddr, vme_size);
			vaddr = sfvme_mmap(fd, vme_size, vme_paddr);
			s = (sbusmapping_t *)malloc(sizeof(sbusmapping_t));
			s->sbus_offset = new_sbus_off;
			s->sbus_size = new_sbus_size;
			s->sbus_vaddr = vaddr;
			s->sbus_next = sbusmaps;
			sbusmaps = s;
			return (vaddr);
		} else {
			return (vaddr);
		}
	} else {
		sbusmapping_t	*s;

		printf("[Doing mmap for VME: 0x%x size 0x%x]\n",
					vme_paddr, vme_size);
		vaddr = sfvme_mmap(fd, vme_size, vme_paddr);
		s = (sbusmapping_t *)malloc(sizeof(sbusmapping_t));
		s->sbus_offset = new_sbus_off;
		s->sbus_size = new_sbus_size;
		s->sbus_vaddr = vaddr;
		s->sbus_next = sbusmaps;
		sbusmaps = s;
		return (vaddr);
	}
}

/*
 * Input:
 *	o vaddr is the starting virtual address that maps the desired
 *	  VME physical address region.
 *	o len is the size in bytes of the desired VME address region.
 *	o pat is the expected test pattern.
 *	o paddr is the starting VME physical address of the region to
 *	  be read.
 */
void
sfvme_read(int *vme_vaddr, int len, int pat, u_int vme_paddr)
{
	int	vme_pat;

	len = len >> 2;
	while (len-- > 0) {
		vme_pat = *(vme_vaddr);
/*		if (vme_pat != pat) {
	             if ((len % PRINTINTERVAL) == 0)
			printf(
		"*** Error: expected 0x%x observed: 0x%x VME_addr: 0x%x\n",
			pat, vme_pat);
		}
*/
		if ((len % PRINTINTERVAL) == 0)
			printf("sfvme_read: VME addr: 0x%x read pat: 0x%x\n",
				 	vme_paddr, vme_pat);
		++vme_vaddr;
		vme_paddr += sizeof(int);
	}
}	/* end of sfvme_read */

/*
 * Input:
 *	o vaddr is the starting virtual address that maps the desired
 *	  VME physical address region.
 *	o len is the size in bytes of the desired VME address region.
 *	o pat is the test pattern used when writing the VME address
 *	  region.
 *	o vme_paddr is the starting VME physical address of the region to
 *	  be written.
 */
void
sfvme_write(int *vme_vaddr, int len, int pat, u_int vme_paddr)
{
	len = len >> 2;
	while (len-- > 0) {
		if ((len % PRINTINTERVAL) == 0)
		printf("sfvme_write: VME addr: 0x%x write pat: 0x%x\n",
					vme_paddr, pat); 
		*(vme_vaddr) = pat;
		++vme_vaddr;
		++vme_paddr;
	}
}	/* end of sfvme_write */
