/*                                                                -*-c++-*-
    Copyright (C) 1996-1997 Kentaro Toyama, Greg Hager (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  ktv_basic.h
//
//  Basic header file for use with K2T V300 framegrabber.  Including this
//  should obviate need to include any other K2T-related header files.  
//
//  ??/04/96 Kentaro Toyama
//-----------------------------------------------------------------------------

#ifndef KTV_BASIC_H
#define KTV_BASIC_H

#include "ktv.h"
#include "ktv_addresses.h"
#include "ktv_colors.h"

//-----------------------------------------------------------------------------
//  External C function declarations
//-----------------------------------------------------------------------------

extern "C" {

  int ktv_clear_overlay();
  int ktv_clear_ram();
  int ktv_enable_overlay(int OnOff);
  int ktv_get_pixel(unsigned char *value, int row, int col);
  int ktv_get_rect(unsigned char **value, int row, int col,
		   int num_rows, int num_cols);
  int ktv_init_mono(int device, int sync_mode);
  int ktv_init_rgb(int device, int sync_mode);
  int ktv_live_mode();
  int ktv_digitize_and_wait();
  int ktv_set_gain(unsigned char red, unsigned char green, unsigned char blue);
  int ktv_start_digitize();
  int ktv_put_overlay_pixel(unsigned char *value, int row, int col);
  int ktv_put_pixel(unsigned char *value, int row, int col);
  int ktv_put_rect(unsigned char **value, int row, int col,
		   int num_rows, int num_cols);
  
}

extern int *KTV_SBUS_BASE;	/* Sbus slot */
extern int *KTV_AQCLKGEN;	/* Acquire clock */
extern int *KTV_ADC;		/* Brooktree 254 - digitizer chip */
extern int *KTV_DAVGEN; 	/* Display clock */
extern int *KTV_DAC;		/* Brooktree display chip */
extern int *KTV_STATREG;	/* Status register */
extern int *KTV_CONTREG;	/* Control register */
extern int *KTV_RED;		/* Red image band */
extern int *KTV_GREEN;		/* Green image band */
extern int *KTV_BLUE;		/* Blue image band */
extern int *KTV_OV;		/* Overlay band */

extern int KTV_ROWS;
extern int KTV_COLS;

enum { NOOVERLAY, WOVERLAY };

#endif

