#include <fcntl.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <sys/file.h>
#include <strings.h>
#include <unistd.h>
#include "sfvmereg.h"
#include "/local/include/itex100.h"
#include "/local/include/IT_framebuffer.h"


main()

{

    int 
        regaddress = REGBASE + camera*32,
        memaddress = MEMBASE + camera*0x80000;
  
    // Do the sethdw
  
    sethdw (REGBASE, MEMBASE, FG_101, MEMORY);
  
    // Go off and do the usual stuff
  
    setdim (FG_WIDTH, FG_HEIGHT, TWELVE_BITS); // 1024 * 1024 frame memory
  
    initialize();		     // initialize registers and LUTs
    setreg (X_SPIN, 0);		     // disable spin compensation
    sclear (0);			     // clear frame memory
    setreg (PAN, ncols);
    sclear (0);
    setreg (PAN, 0);
    setvmask (0xf00);		     // don't let IT_FG101 change overlay
    setpmask (0x0ff);		     // processor only affects overlay
    setcamera (channel);		     // select which input to use
    dynamic_luts();		     // use top four bits for overlays
  
    grab (0);			     // start digitizing
  
    // Enable host memory addressing.  Anything that changes this
    // should change it back when it is done.
  
    setreg (POINTER_CONTROL, 0x0044);	     // reset pointer control
    setreg (CPU_ADR_CONTROL, 0x0407);	     // allow CPU memory mapping
  
}
