#ifndef Videre_h
#define Videre_h

#include <sys/types.h>
#include <svs.h>
#include "Video.hh"

#define DC_DEVICE_NAME  "/dev/video1394"
#define DIG_DEF_NUMFRAMES 4

typedef struct
{
     char c;                      // parameter specification e.g. B
     int  val;                    // assigned value
}XVParser; 

class Videre : public MonoVideo {
  static int  ninstances;
  static int  gotfirst;
  static int  fd;
  static int  node_id;
  static int  buffer_id;
  static int  scale;
  static int  scheduled;
  static int  raw_rgb;
  static ulong *dataPtr;
  void error_exit(char *mesg);
  int checknew(void);
  
public:
  
  Videre (char *filename);
  ~Videre();
  int open (void);
  void close(void);
  
  long window();
  
  // In the Indy's case, this handles getting new images in the
  // ring buffer.
  int set_params(char *paramstring);
  
  virtual int pre_grab();
  
  
  virtual void *current_frame_ptr(void);
  // No display capabilities

  virtual int show (int x, int y,
		    int width, int height,	     // show image 
		    int *image) {return 0;};

  virtual void line (float x, float y, int length, float angle,
		     Color color = default_color,int samp = 1) {};


};

// include inline functions
#include "Videre.icc"

#endif

