//-----------------------------------------------------------------------------
//
//  Videre.cc
//
//  Definition of Videre member functions.
//
//  07/06/94 Greg Hager
//  ??/??/96 Greg Hager various improvements.
//
//-----------------------------------------------------------------------------

#include <site_config.h>
#ifdef USE_IEEE1394

#include <stdlib.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/mman.h>

#include "Video.hh"
#include "Acquire.hh"
#include "Videre.hh"

int Videre::fd = -1;
int Videre::gotfirst = 0;
int Videre::ninstances = 0;
long win;
ulong *Videre::dataPtr=NULL;


int Videre::open() {
 svsSP  sp=svsParams;
 svsSP  parameter_copy=sp;

 if(!svsVideoOpen(&parameter_copy)<0) exit(1);
 svsVideoStartContinuous(&sp);
 svsVideoSetDigParams(&sp);
  return 1;
}



Videre::Videre(char * filename):
MonoVideo(1,320,240) 
{

  ninstances++;
  
  // There is supposed to be a color mode, but I've never seen it work
  
  set_input_type(PIX_PACKED);

  // The first instance opens up the camera and gets things set.
  
  if (ninstances == 1) {
     svsReadParamFile(filename,NULL);
     open();
  }
  
  ncols = width();
  nrows = height();
   
  dataPtr = NULL;
}



void*
Videre::current_frame_ptr() 
{
  pre_grab();
  return dataPtr;
}

void
Videre::close() 
{
  
  ninstances --;
  if (ninstances == 0) {
    svsVideoHaltContinuous();
    svsVideoClose();
  }
}


int
Videre::checknew()
{
  unsigned char *right_image;

  if(svsVideoCheckImage())
  {
     svsVideoGetImage((unsigned char**)&dataPtr,&right_image,NULL);
  }

  return 0;
}


int
Videre::pre_grab() 
{
  
  checknew();
  
  if (!gotfirst) {
    while (dataPtr == NULL)
      checknew();
    gotfirst = 1;
  }
  
  if (dataPtr == NULL)
    return 0;
  else
    return 1;
}

#endif 
