//-------------------------------------------------------------- -*-c++-*- ----
//
// RTVC.hh
//
//  XVision device class for Sun RTVC camera.
//
//  11/26/96  lsh@cs.brown.edu (Loring Holden)
//
//-----------------------------------------------------------------------------

#ifndef RTVC_h
#define RTVC_h

#include <xil/xil.h>

#define BUILT_IN 0

#include "Video.h"

//-----------------------------------------------------------------------------
//  Class : RTVC
//
//* Device class for the Sun RTVC camera.  
//-----------------------------------------------------------------------------

class RTVC : public ColorVideo {
  
  // The following variables are declared statically so that multiple
  // instances of the video class can share the same image if, for 
  // for example, there are multiple cameras hooked up as a single color
  // image.  Right now this isn't quite what it should be since
  // all of the images are shown in the same window.
  
  static XilSystemState state;
  static XilColorspace cspace_ycc601;
  static XilColorspace cspace_rgb709;
  static XilLookup yuv_to_rgb;
  static XilImage rtvc_image, display, scaled_image;
  static XilMemoryStorage layout;
  
  static unsigned char *dataPtr;
  static int ninstances;
  static long win;    
  static float scale_factor;
  
  int info_type;
  
  void error_exit(char *mess = NULL);
  
  int map_color(Color x);
  void set_color(Color x);
  
public:
  
  RTVC(int in_color = 0);
  ~RTVC();
  void close();
  
  long window();
  
  virtual char *device_info();
  virtual void set_grab_type(Device_output_type ot);
  virtual int pre_grab();
  virtual void *current_frame_ptr();
  
  // Show an image on the RTVC screen at the specified location
  // with the specified height and width.
  
  int show (int x, int y, int width, int height, int *image);
  
  // Draw and clear a graphic overlay on the RTVC screen
  //   line:  endpoint and length
  //   line2:  two endpoints
  
  void line (float x, float y, int length, float angle,
	     Color color = default_color,int samp = 1);
  
  void line2 (float x1, float y1, float x2, float y2, 
	      int color = default_color);
  
  // Draw and clear a circle on the RTVC screen
  
  void circle (float x, float y, int r, 
	       int color = default_color);
  void clearcircle(float x, float y,  int r);
  
  // Draw and clear a cubic-polynomial segment
  
  void cubic (float x, float y, int length, float angle,
	      float a, float b, float c, 
	      int color = default_color);
  void clearcubic (float x, float y, int length, float angle,
		   float a, float b, float c);
  
};

// include inline functions
#include "RTVC.icc"

#endif
