//-------------------------------------------------------------- -*-c++-*- ----
//
// RTVC.cc
//
//  RTVC class member functions.
//  Most of this code is from the vic package.
//
//  11/26/96  lsh@cs.brown.edu (Loring Holden)
//
//-----------------------------------------------------------------------------

#include <site_config.h>
#ifdef USE_RTVC

#include <stdlib.h>
#include "Video.h"
#include "Acquire.h"
#include "RTVC.h"

unsigned char *RTVC::dataPtr = 0;
int RTVC::ninstances;
long RTVC::win;

XilSystemState RTVC::state = 0;
XilColorspace RTVC::cspace_ycc601;
XilColorspace RTVC::cspace_rgb709;
XilImage RTVC::rtvc_image,
RTVC::display,
RTVC::scaled_image;
float RTVC::scale_factor = 0.5;
XilMemoryStorage RTVC::layout;

void RTVC::error_exit(char *mess) {
  if (mess != NULL) 
    cerr << mess << endl;
  else
    cerr << "Some problem with the RTVC setup" << endl;
  exit(1);
}

RTVC::RTVC(int color) : ColorVideo(4,0,0)
{
  
  ninstances++;
  
  if (color) set_grab_type(PIX_PACKED);
  else set_grab_type(PIX_LUMINANCE);
  
  // The first instance opens up the camera and gets things set.
  
  if (ninstances == 1) {
    
    // Connect to the daemon 
    if (state == NULL) {
      if ((state = xil_open()) == 0) {
	cerr << "Unable to open RTVC Server" << endl;
	exit(1);
      }
    }
    
    // 
    if (!(rtvc_image = xil_create_from_device(state, "SUNWrtvc", 0))) {
      fprintf(stderr, "ANIMrtvc: failed to open SUNWrtvc device\n");
      xil_close(state);
      exit(1);
    }
    int port = 1;
    xil_set_device_attribute(rtvc_image, "PORT_V", (void *) port);
    xil_set_device_attribute(rtvc_image, "MAX_BUFFERS", (void *) 1);
    
    
    {
      int format;
      if (xil_get_device_attribute(rtvc_image,
				   "FORMAT_V", (void **) &format) != XIL_SUCCESS) {
	fprintf(stderr, "Could not get video format.\n");
	xil_close(state);
	exit(1);
      }
      if (format == 0) {
	fprintf(stderr, "Unknown video format on port %d.\n", port);
	xil_close(state);
	exit(1);
      }
    }
    
    // Get the video size 
    unsigned int nbands;
    {
      unsigned int Width, Height;
      XilDataType datatype;
      xil_get_info(rtvc_image, &Width, &Height, &nbands, &datatype);
      ncols = (int) (((float) Width * scale_factor) + 0.5);
      nrows = (int) (((float) Height * scale_factor) + 0.5);
    }
    scaled_image = xil_create(state, ncols, nrows, nbands, XIL_BYTE);
    if (scaled_image == 0) {
      fprintf(stderr, "ANIMrtvc: couldn't create scaled_image\n");
      exit(1);
    }
    display = xil_create(state, ncols, nrows, nbands, XIL_BYTE);
    if (display == 0) {
      fprintf(stderr, "ANIMrtvc: couldn't create display image\n");
      exit(1);
    }
    
    set_fg_size(nrows, ncols);
    
    // Get colorspace info
    cspace_ycc601 = xil_colorspace_get_by_name(state, "ycc601");
    cspace_rgb709 = xil_colorspace_get_by_name(state, "rgb709");
    
    // Create buffer for 1 frame 
    dataPtr = new unsigned char[ncols * nrows * 4];
    xil_set_colorspace(scaled_image, cspace_ycc601);
    xil_set_colorspace(display, cspace_rgb709);
    memset(dataPtr, 0, ncols * nrows * nbands);
  }
}

void RTVC::close() {
  
  ninstances --;
  if (ninstances == 0) {
    delete [] dataPtr;
    xil_destroy(display);
    xil_destroy(rtvc_image);
    xil_destroy(scaled_image);
  }
}

void
RTVC::set_grab_type(Device_output_type ot) 
{
  output_type = ot;
  if (output_type == PIX_LUMINANCE)  {
    set_input_type(PIX_LUMINANCE);
  } else set_input_type(PIX_PACKED);
}


int 
RTVC::pre_grab() 
{
  xil_scale(rtvc_image, scaled_image, "nearest",
	    scale_factor, scale_factor);
  xil_toss(rtvc_image);
  
  if (input_type == PIX_LUMINANCE) {
    // Don't convert to RGB, just use Y value from YUV camera data
    if (xil_export(scaled_image) != XIL_SUCCESS) {
      printf("could not export\n");
      return FALSE;
    }
    if (xil_get_memory_storage(scaled_image, &layout) == 0) {
      fprintf(stderr, "xil_get_memory_storage failed on image\n");
      return FALSE;
    }
    const int istride = layout.byte.scanline_stride;
    register unsigned char *srcdata = layout.byte.data;
    register unsigned char *data = (unsigned char *) dataPtr;
    unsigned char *tmpsrc;
    
    int x, y;
    for (y = 0; y < nrows; y++) {
      tmpsrc = srcdata;
      for (x = 0; x < ncols; x++) {
	// output data format is XRGB (full color) or
	// in this case XXXY
	//
	// input data format is YUV
	//
	data[3] = srcdata[0];
	data += 4;
	srcdata += 3;
      }
      srcdata = tmpsrc + istride;
    }
    
    xil_import(scaled_image, 0);
    xil_toss(scaled_image);
    
  } else // PIX_PACKED - full color  {
    
    // We need to convert to RGB
    xil_color_convert(scaled_image, display);
  // Then throw away the YUV version
  // We *must* do this or the frame rate drops a *lot*
  xil_toss(scaled_image);
  
  // Export it from xil to normal memory space
  // (is there an easier way?)
  if (xil_export(display) != XIL_SUCCESS) {
    printf("could not export\n");
    return FALSE;
  }
  
  if (xil_get_memory_storage(display, &layout) == 0) {
    fprintf(stderr, "xil_get_memory_storage failed\n");
    return FALSE;
  }
  if (layout.byte.pixel_stride != 3) {
    fprintf(stderr, "xil: bad pixel stride\n");
    return FALSE;
  }
  
  int istride = layout.byte.scanline_stride;
  
  // This is a pain because the image from xil is 3 bytes/pixel,
  // and the XImage data is 4 bytes/pixel, so we have to copy it
  // "by hand"
  // gotta be a better way
  register unsigned char *srcdata = layout.byte.data;
  unsigned char *tmpsrc;
  unsigned char *data = (unsigned char *) dataPtr;
  int x, y, z;
  for (y = 0; y < nrows; y++) {
    tmpsrc = srcdata;
    for (x = 0; x < ncols; x++) {
      for (z = 0; z < 3; z++) {
	data[z + 1] = srcdata[z];
      }
      data += 4;
      srcdata += 3;
    }
    srcdata = tmpsrc + istride;
  }
  
  xil_import(display, 0);
  xil_toss(display);
}

return 1;
}

void
RTVC::set_color(Color x) 
{
  int y = map_color(x);
  char *xx = (char *)(&y);
}

int
RTVC::map_color(Color x) 
{
  int temp = 0;
  char *rptr = ((char *)&temp);
  char *gptr = ((char *)&temp)+1;
  char *bptr = ((char *)&temp)+2;
  
  //  cout << "Color is " << x << endl;
  
  switch (x) {
  case no_color:
    return 0;
    break;
    
  case green_color:
    *gptr = 255;
    break;
    
  case red_color:     
    *rptr = 255;
    break;
    
 case blue_color:    
    *bptr = 255;
    break;
    
  case yellow_color:
    *gptr = 100;
    *bptr = 100;
    break;
    
  case purple_color:
    *rptr = 100;
    *bptr = 100;
    break;
    
  case cyan_color:    
    *gptr = 100;
    *rptr = 100;
    break;
    
  case white_color:   
    *rptr = *gptr = *bptr = 255;
    break;
    
  case black_color:
    break;
    
  default:
    temp = (int )x;
    break;
    
  }
  
  return temp;
}


// Show an image on the RTVC screen at the specified location
// with the specified height and width.

int
RTVC::show (int x, int y,int width, int height,int *image)
{
  cerr << "RTVC::show(" << x << " , " << y << " , " << width << " , " <<
    height << " , image)" << endl << flush;
  return 1;
}

// Draw and clear a graphic overlay on the RTVC screen
//   line:  endpoint and length
//   line2:  two endpoints

void 
RTVC::line (float x, float y, int length, float angle,
	    Color color,int samp)
{
  if (in_view(x,y,
	      ceil(cos(angle)*length),
	      ceil(sin(angle)*length))) {
    
    length/=2.0;
    float vec[2];
  }
}

// !!! Get rid of this?
void 
RTVC::line2 (float x1, float y1, float x2, float y2, 
	     int color)
{
}

// Draw and clear a circle on the RTVC screen
// !!! Get rid of these?
void
RTVC::circle (float x, float y, int r, int color)
{
}

void
RTVC::clearcircle(float x, float y, int r)
{
}

// Draw and clear a cubic-polynomial segment
// !!! Get rid of these?
void RTVC::cubic (float x, float y, int length, float angle,
		  float a, float b, float c, int color)
{
}

void RTVC::clearcubic (float x, float y, int length, float angle,
		       float a, float b, float c)
{
}

#endif USE_RTVC
