/*                                                               -*-c++-*-
    Copyright (C) 1991-1997 Gregory D. Hager, Kentaro Toyama (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.
*/
//-----------------------------------------------------------------------------
//
//  RGB2int.hh
//
//  Functions to perform RGB to X conversions, where X can be red, green, blue,
//  intensity, luminance, hue, saturation, packed, etc.
//
//  ??/04/96 Kentaro Toyama
//  ??/07/96 Greg Hager
//
//-----------------------------------------------------------------------------
#ifndef RGB2int_H
#define RGB2int_H

#include "Tools.hh"

#ifndef NEUTRAL_PIXEL
#define NEUTRAL_PIXEL 512
#endif

unsigned int 
compute_hsi_packed (unsigned char r,unsigned char g,unsigned char b);

unsigned int 
compute_hue (unsigned char r,unsigned char g,unsigned char b);

unsigned int 
compute_intensity (unsigned char r,unsigned char g,unsigned char b);

unsigned int 
compute_saturation (unsigned char r,unsigned char g,unsigned char b);

// include inline functions
#include "RGB2int.icc"

#endif
