/*                                                                -*-c++-*-
    Copyright (C) 1991-1997 Gregory D. Hager, Kentaro Toyama (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.
*/
//-----------------------------------------------------------------------------
//
//  RGB2int.cc
//
//  RGB2int functions definitions.
//
//  ??/04/96 Kentaro Toyama
//  ??/07/96 Greg Hager
//  02/07/97 Kentaro Toyama
//
//-----------------------------------------------------------------------------

#include "RGB2int.hh"

// Compute hsi "" with the result back as a character

unsigned int 
compute_hsi_packed (unsigned char r,unsigned char g,unsigned char b)
{
  int ret,whichm,mx,mn;
  unsigned char *pix = (unsigned char *)&ret;
  float hue,sat,delta;

  if (r > g) {
    whichm = 1;
    mx = r;
    mn = g;
  }
  else {
    whichm = 2;
    mn = r;
    mx = g;
  }

  if (b < mn) 
    mn = b;
  else
    if (b > mx) {
      whichm = 3;
      mx = b;
    }

  delta = mx-mn;
  sat = delta/mx;

  // Intensity
  pix[3] = (unsigned char)mx;

  // Saturation
  pix[2] = (unsigned char)(255 * sat);

  // Hue
  if ((mx < 25.0) || (mn > 230.0))
    hue = (float) NEUTRAL_PIXEL;
  else if (sat < 0.05)
    hue = (float) NEUTRAL_PIXEL;
  else {
    delta *= 42.0;
    switch (whichm) {
    case 1:
      hue = (g-b)/delta;
      break;

    case 2:
      hue = 2.0*42.0 + (b-r)/delta;
      break;

    case 3:
      hue = 4.0*42.0 + (r-g)/delta;
    }
    if (hue < 0.0)
      hue += 252.0;
  }
  pix[1] = (unsigned char)round(hue);

  return ret;
}

 
unsigned int 
compute_hue (unsigned char r,unsigned char g,unsigned char b)
{
  int ret,whichm,mx,mn;
  unsigned char *pix = (unsigned char *)&ret;
  float hue,sat,delta;

  if (r > g) {
    whichm = 1;
    mx = r;
    mn = g;
  }
  else {
    whichm = 2;
    mn = r;
    mx = g;
  }

  if (b < mn) 
    mn = b;
  else
    if (b > mx) {
      whichm = 3;
      mx = b;
    }

  delta = (mx-mn)*42.0;
  sat = delta/mx;

  // Hue
  if ((mx < 25.0) || (mn > 230.0))
    hue = (float) NEUTRAL_PIXEL;
  else if (sat < 0.05)
    hue = (float) NEUTRAL_PIXEL;
  else {
    switch (whichm) {
    case 1:
      hue = (g-b)/delta;
      break;

    case 2:
      hue = 2.0*42.0 + (b-r)/delta;
      break;

    case 3:
      hue = 4.0*42.0 + (r-g)/delta;
    }
    if (hue < 0.0)
      hue += 252.0;
  }
   return round(hue);

  return ret;
}

unsigned int 
compute_intensity (unsigned char r,unsigned char g,unsigned char b)
{
  return max2(max2(r,g),b);
}

unsigned int 
compute_saturation (unsigned char r,unsigned char g,unsigned char b)
{
  int ret,mx,mn;
  unsigned char *pix = (unsigned char *)&ret;
  float hue,sat;

  if (r > g) {
    mx = r;
    mn = g;
  }
  else {
    mn = r;
    mx = g;
  }

  if (b < mn) 
    mn = b;
  else
    if (b > mx) {
      mx = b;
    }
  if (mx == 0) return (0);      // line added 1/15/97 ZD
  return (255 *(mx-mn))/mx;
}

