//-----------------------------------------------------------------------------
//
//  Meteor.h
//
//  Specification of the Meteor class, which provides an interface between
//  tracking software and Matrox Meteor hardware.
//
//  7.1.1997
//  Jouni Aro <jaro@iki.fi>
//
//  Written based on DT3155.h by Greg Hager
//  and Linux meteor driver by Jim Bray
//  (original version by Mark Tinguely and Jim Lowe)
//
//  Uses a meteor driver installed as a linux kernel module.  Grabbing
//  is done using continuous frame capture to memory mapped area.
//
//  Both monochrome and colour signals are used, though I have used
//  only monochrome, so you may need to make changes to the code if
//  you need colour.
//
//  You will need the meteor driver from:
//  	<http://www.cs.virginia.edu/~bah6f/matrox/>
//-----------------------------------------------------------------------------

#ifndef Meteor_h
#define Meteor_h

//  Define PAL or SECAM if your input is not from NTSC (default)
//  (preferably in the makefile)
//
//#define PAL
//#define SECAM

#include "meteor.h"
#include "ioctl_meteor.h"
#include "Video.hh"

#define PIXEL 

#if defined(PAL)
#define MAXROWS 576
#define MAXCOLS 768
#define DEFAULT_FORMAT METEOR_FMT_PAL
#define MAXFPS 25
#elif defined(SECAM)
#define MAXROWS 576
#define MAXCOLS 768
#define DEFAULT_FORMAT METEOR_FMT_SECAM
#define MAXFPS 25
#else /* NTSC */
#define MAXROWS 480
#define MAXCOLS 640
#define DEFAULT_FORMAT METEOR_FMT_NTSC
#define MAXFPS 30
#endif

#define NOFRAMES 1
#define MAXPIXELSIZE 4
#define MAXSIZE (NOFRAMES*MAXPIXELSIZE*MAXROWS*MAXCOLS)

extern int newframecaptured;/* this sucker can be used to poll for newimages
			       by settiing equal to 0 and then looking for 
			       when it goes to 1 */

//-----------------------------------------------------------------------------
//  Meteor class declaration
//-----------------------------------------------------------------------------
class Meteor : public ColorVideo 
{

  int device;				// file descriptor



  struct meteor_geomet geo;		// rows, colums, frames, oformat
  struct meteor_frame_offset off;	// frame offset for multiple frames
  
  void error_exit(char *mess = NULL);
  
  int map_color(int x) {return 1;};

  void mmap();
public:
  // pointer to the image data
  char* dataPtr;

  // Define the number of bytes if you use colour signals
  Meteor (int nbytes=1, int cols=MAXCOLS, int rows=MAXROWS,
	  char *input_dev = "/dev/meteor0");
  // in Video.h  ~Meteor() { close(); }

  ~Meteor();

  // Device information

  char *device_info(){return "Matrox Meteor Capture card";};

  void close();
  void start();
  void stop();
  int resize(int cols, int rows);

  // We allow the Meteor to be directly address bypassing the
  // usual "grab" routines if desired.

  //  int bytesperpixel() {return 1;}; 
  virtual void *direct_memptr() { return (_is_mappable) ? 
				    current_frame_ptr() : NULL;};
  virtual int  bytesperpixel()  const {return _bytesperpixel;};

  // Nothing to be done

  virtual int pre_grab() { return 1; };

  // Just return the current image

  virtual void *current_frame_ptr() { pre_grab(); return dataPtr; };

  //    virtual void set_grab_type
#if 0
  int grab_aligned (int *image, float &x, float  &y,
		    int width, int height,
		    int sampw, int samph, short int mask);
#endif

  // No display capabilities

  virtual int show (int x, int y,
		    int width, int height,	     // show image 
		    int *image) {return 0;};

  virtual void line (float x, float y, int length, float angle,
		     Color color = default_color,int samp = 1) {};



};

#endif
