//-----------------------------------------------------------------------------
//
//  Meteor.cc
//
//  Definition of Meteor class member functions.
//
// 	Initialisation routines shamelessly stolen from 'vu4'
//	(Copyright (C) 1996  Jim Bray)
//
//  7.1.1997
//  Jouni Aro <jaro@iki.fi>
//
//-----------------------------------------------------------------------------

#include <site_config.h>
#ifdef USE_METEOR

extern "C" {
#include <sys/types.h>
#include <sys/mman.h>
#include <sys/fcntl.h>
#include <sys/signal.h>
#include <sys/ioctl.h>
#include "ioctl_meteor.h"
}

extern int errno;
#include <sys/signal.h>
#include <stdlib.h>
#include "Video.hh"
#include "Acquire.hh"
#include "Meteor.hh"
#include <stdio.h>

// what type of signal do we want to use for the interrupts 
// #define SIGNAL_OF_CHOICE SIGUSR1
#define SIGNAL_OF_CHOICE SIGUSR2

static Meteor *BLORT = NULL;

static void gotframe(int);

/* signal structure */
/* initialize EXPLICITLY or system calls will be unhappily interrupted */
static struct sigaction sigact;

int newframecaptured;
static char *dataBuffer = NULL;
static char *dataPtr1 = NULL;			// memory mapped area for frame 1
static char *dataPtr2 = NULL;	                // memory mapped area for frame 2
static int sigmode = 0x0;

static void gotframe(int sig)
{
  newframecaptured = 1;
#if (NOFRAMES == 2)
#error "lets keep the number of frames at 1 for now"
  if (BLORT->dataPtr == dataPtr1)
    BLORT->dataPtr = dataPtr2;
  else
    BLORT->dataPtr = dataPtr1;       
#endif
}

void Meteor::error_exit(char *mess) {
  if (mess != NULL) 
    cerr << "Meteor: " << mess << endl;
  else
    cerr << "Some problem with the Meteor setup" << endl;
  if (errno)
    perror("ioctl");
  exit(1);
}

Meteor::~Meteor()
{
  close();
  BLORT=NULL;
}


Meteor::Meteor(int nbytes, int cols, int rows, char *input_dev) 
  : ColorVideo(nbytes,cols,rows) 
{
  int c;

  // (hack) check to see if Meteor has already been instantiated
  // and choke if it has...
  if (BLORT)
    error_exit("Limit one meteor per customer, please");
  else
    BLORT = this;

  // Open the device first

  errno = 0;
  if ((device = open(input_dev, O_RDWR)) < 0)
    error_exit("open failed");

  printf("Opened %s, file descriptor is %d\n", input_dev, device);

  // Signal format 

  c = DEFAULT_FORMAT;

  if (ioctl(device, METEORSFMT, &c) < 0)
    error_exit("SetFormat failed");

  // Input channel

  c = METEOR_INPUT_DEV_RCA;
  //c = METEOR_INPUT_DEV_SVIDEO;

  if (ioctl(device, METEORSINPUT, &c) < 0)
    error_exit("SetInput failed");

  if (c==METEOR_INPUT_DEV_RGB && geo.oformat==METEOR_GEO_RGB16)
    {
      // set RGB section for 15 bit colour
      u_short s = (0x4 << 4);
      if (ioctl(device, METEORSBT254, &s))
	error_exit("SetBt254 failed");
    }

  
  // Memory map

  mmap();


  // directly access the frame buffer array data in dataPtr

   _is_mappable = 1;

   // Start capture

   sigact.sa_handler = gotframe;
   sigact.sa_flags = SA_RESTART;
   sigact.sa_restorer = 0;
   sigemptyset(&sigact.sa_mask);
   sigaddset(&sigact.sa_mask, SIGNAL_OF_CHOICE);
  
   if (sigaction(SIGNAL_OF_CHOICE, &sigact, NULL) ) {
     error_exit("sigaction failed");
   }
   
   c = SIGNAL_OF_CHOICE | sigmode;
   if (ioctl(device, METEORSSIGNAL, &c) < 0) {
     error_exit("ioctl SetSignal failed");
   }
    
#if 0
   // we disable auto-gain-control in the device driver to stop
   // brightness levels from fluctuating wildly
   c = 50; if (ioctl(device, METEORSBRIG, &c) < 0) error_exit("SetBright failed");
   c = 70; if (ioctl(device, METEORSCONT, &c) < 0) error_exit("SetContrast failed");
#endif

   start();

}

#include <unistd.h>
void Meteor::close()
{
  //funvisit("Meteor::close");
  printf("Meteor::close");
  stop();
  if(dataBuffer) munmap(dataBuffer, off.fb_size );
  dataBuffer=NULL;
  cout << "file decriptor for close is " << device << endl;
  ::close(device);
  geo.columns = 0;
  geo.rows = 0;
}

void Meteor::start()
{
  // start continuous frame capture

  int c = METEOR_CAP_CONTINOUS ;
  
  if (ioctl(device, METEORCAPTUR, &c))
    error_exit("Stop Capture failed");
  printf("Capture started, %dx%d at %p\n", width(), height(), dataPtr);
}


void Meteor::stop()
{
  // stop continuous frame capture
  
  int c = METEOR_CAP_STOP_CONT;
  if (ioctl(device, METEORCAPTUR, &c))
    error_exit("Stop Capture failed");
  printf("Capture stopped\n"); fflush(stdout);
}

void Meteor::mmap()
{
  // If we have already mapped the memory it needs to
  // be unmapped first

  if (dataBuffer)
    {
      printf("should not be here if this is a reinitialization!\n");
      // If size hasn't changed, no need to do anything      
      if (width() == geo.columns && height() == geo.rows)
	return;
      
      // First stop capturing

      stop();

      // Then unmap

      munmap(dataBuffer, off.fb_size );
    }
     
  // Set the geometry

  geo.columns = width();
  geo.rows = height();
  geo.frames = NOFRAMES;
  switch(bytesperpixel())
    {
    case 1:
      input_type = PIX_LUMINANCE;
      output_type = PIX_LUMINANCE;
      geo.oformat = METEOR_GEO_YUV_PLANAR;
      printf("Out format set to YUV_PLANAR\n");
      break;
    case 2:
      geo.oformat = METEOR_GEO_RGB16 ; 
      printf("Out format set to GEO_RGB16\n");
      printf("Warning: this option is not completely worked out\n");
      break;
    case 4:
      geo.oformat = METEOR_GEO_RGB24;
      printf("Out format set to GEO_RGB24\n");
      break;
    default:
      fprintf(stderr,
	      "only 1, 2 or 4 bytes per pixels allowed, you tried %d\n", 
	      bytesperpixel());
      exit(1);
    }


  if (ioctl(device, METEORSETGEO, &geo) < 0)
    error_exit("mmap: SetGeometry failed");

  // Get Frame offset

  if (ioctl(device, METEORGFROFF, &off) < 0)
    error_exit("mmap: FrameOffset failed");

  // memory map device to kernel

  long size = bytesperpixel()*width()*height();
 
  dataBuffer=(char *) ::mmap( (caddr_t)0, off.fb_size, PROT_READ|PROT_WRITE,
			   MAP_FILE|MAP_SHARED, device, (off_t)0);

  // printf("off.fb_size = %i\n", off.fb_size);
  // printf("size = %d\n", size);
  
  // cout << "dataPtr1 at offset " << off.frame_offset[0] << endl;
  dataPtr1 = dataBuffer + off.frame_offset[0]; 
  dataPtr = dataPtr1;

#if (NOFRAMES == 2)
  // cout << "dataPtr2 at offset " << off.frame_offset[1] << endl;
  dataPtr2 = dataBuffer + off.frame_offset[1]; 
  // offset equivalent to (off.fb_size - size - 4096)
#endif

  // printf("off.frame_offset[0] = %i\n", off.frame_offset[0]);
  // printf("off.mem_off = %i\n", off.mem_off);

  if (dataBuffer == (char *) -1)
    error_exit("mmap failed");
} 

int Meteor::resize(int cols, int rows)
{
  if ( (cols > MAXCOLS) || (rows > MAXROWS) )
    {
      return 0;
    }
  set_size( cols, rows );
  mmap();
  return 1;
}

#if 0
int Meteor::grab_aligned (int *image, float &x, float  &y,
 			 int width, int height,
			 int sampw, int samph, short int mask) 
{
  
  int i,j;
  int fx,fy;
  int rskip;
  register unsigned char *ldata, *endldata, *finalldata;

  if (!pre_grab())
    {
      return 0;
    }

  if (!(in_view(x,y,width*sampw,height*samph)))
    {
      return 0;
    }



  if (_bytesperpixel == 1)
    {
      _bytesperpixel = 2;
      short int yuvmask = 0Xff;
 
      fx = adjust_to_first_coord(x,width*sampw);
      fy = adjust_to_first_coord(y,height*samph);
  
      width *=sampw;
      rskip  = samph*ncols;
  
      ldata = (unsigned short *)dataPtr + fy*ncols+fx;
      finalldata = ldata + rskip*height;//(height-1) + width;
      rskip -= width;
      i=0;
      for(;ldata<finalldata;ldata += rskip) {
	for(endldata = ldata+width;ldata< endldata;ldata+=sampw)
	  {
	    *image++ = *ldata & yuvmask;
	    i++;
	  }
      }	
      _bytesperpixel = 1;
    }
  else
    {
    }
}

#endif



#endif // USE_METEOR
  
