/*                                                                -*-c++-*-
    Copyright (C) 1996-1997 Gregory D. Hager, Kinh Tieu
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  MPEG.hh
//
//  Declaration of the MPEG class.
//
//  10/21/96 Kinh Tieu, using
//
//                        The MPEG Library
// 
//                  Version 1.2 - 17 October, 1995
// 
// MPEG decoding engine (c) 1992 The Regents of the University of California
// Front end (c) 1994-95 Gregory P. Ward (greg@bic.mni.mcgill.ca)
//
// Copyright (c) 1994-95 by Gregory P. Ward.
// All rights reserved.
// 
// IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT,
// INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
// OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE
// UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
// THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT
// NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER
// IS ON AN "AS IS" BASIS, AND THE AUTHOR HAS NO OBLIGATION TO PROVIDE
// MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.  
//
//  and modeled on code for IMG_SEQ by Greg Hager and Jonathan Wang.
//
//-----------------------------------------------------------------------------

#ifndef MPEG_h
#define MPEG_h

#include <stdio.h>

#include "Tracker.hh"
#include "XConsole.hh"
#include "XWindow.hh"
#include "Image.hh"
#include "Video.hh"
#include "Tools.hh"

extern "C" {
#include "mpeg.h"       // for mpeg lib
}

//-----------------------------------------------------------------------------
//  Class : MPEG
// 
//* Class MPEG provides an interface between tracking and MPEG files,
//* allowing users to use MPEG sequences as a source of video sequences.
//*
//* See also, Class Image_SequenceMono (in files IMG_SEQ.*).
//-----------------------------------------------------------------------------

class MPEG : public ColorVideo {

  Image vimage;  // store mpeg image frame here

  char *name;
  FILE *mpeg_file;
  ImageDesc img_info;
  int *lum_values, *cr_values, *cb_values;

  int frame_count;
  int auto_step_mode;       // Whether to just increment with each grab
 
  XConsole con;  // with color
 
  XWindow *win;	

protected:

  int map_color(Color colin);

  //* Protected function that constructs file names.  It assumes the user 
  //* supplies a format string with a single %d directive for the image 
  //* number.
  void construct_name(char *buff);

public:

  MPEG (char *fname);
  ~MPEG();
  void close();

  char *device_info();

  // Set it up so the default video interfaces work

  virtual int pre_grab();
  virtual void *current_frame_ptr();

  //* Grab an image, but do not forward the sequence (i.e., grab the same
  //* image again, in absence of explicit command to do otherwise).
  virtual int grab_static(int *im, int x, int y, int width, int height,
		  float angle = 0.0, int sampw = 1, int samph = 1,
		  short int mask = 0xff);

  //* Set auto_step_mode, which forces forwarding of the sequence after
  //* bval number of calls to grab. 
  int auto_step(int bval);

  //* This loads an image and forces the sequence forward by one step.
  //* Should be called explicitly in the event that update_step is 0.
  virtual int forward();
  
  // Show an image on the MPEG screen at the specified location
  // with the specified height and width.

  int show (int x, int y, int width, int height, int* image);

  // Draw and clear a graphic overlay on the MPEG screen
  //   line:  endpoint and length
  //   line2:  two endpoints

  void point (int x, int y, Color color = 1, int size=1);
 
  void line (float x, float y, int length,   // draw an overlayed line
	     float angle,
	     int color = 1,int samp = 1);

  void clearline (float x, float y,	     // clear overlayed line
		  int length, float angle, int samp = 1);

  // Draw and clear a circle on the MPEG screen

  void circle (float x, float y, int r, int color = 1);
  void clearcircle(float x, float y,  int r);

  // Draw and clear a cubic-polynomial segment

  void cubic (float x, float y, int length, float angle,
	      float a, float b, float c, int color = 1);
  void clearcubic (float x, float y, int length, float angle,
		   float a, float b, float c);

};

// include inline functions
#include "MPEG.icc"

//-----------------------------------------------------------------------------
#endif
