/*                                                                -*-c++-*-
    Copyright (C) 1996-1997 Gregory D. Hager, Kinh Tieu (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  MPEG.cc
//
//  Definition of MPEG class member functions.
//
//  10/21/96 Kinh Tieu, using
//
//                        The MPEG Library
// 
//                  Version 1.2 - 17 October, 1995
// 
// MPEG decoding engine (c) 1992 The Regents of the University of California
// Front end (c) 1994-95 Gregory P. Ward (greg@bic.mni.mcgill.ca)
//
// Copyright (c) 1994-95 by Gregory P. Ward.
// All rights reserved.
// 
// IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT,
// INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
// OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE
// UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
// THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT
// NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER
// IS ON AN "AS IS" BASIS, AND THE AUTHOR HAS NO OBLIGATION TO PROVIDE
// MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.  
//
//  and modeled on code for IMG_SEQ by Jonathan Wang and Greg Hager.
//
//-----------------------------------------------------------------------------

#include <fcntl.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <stdlib.h>
#include <sys/file.h>
#include <unistd.h>
#ifdef __GNUC__
#include <string.h>
#else
#include <strings.h>
#endif

#include "Video.hh"
#include "Acquire.hh"
#include "MPEG.hh"

//-----------------------------------------------------------------------------
//  Constructor and destructor
//-----------------------------------------------------------------------------

MPEG::MPEG(char *fname) : 
ColorVideo(4), 
con(1)
{
  // initializations

  auto_step_mode = 1;
  frame_count = 0;

  name=fname;

  if ( (mpeg_file = fopen(fname, "rb")) == NULL) { // get mpeg FILE for OpenMPEG
    panic("Can't open MPEG file!");
  }

  SetMPEGOption(MPEG_DITHER, FULL_COLOR_DITHER); // set dither mode
  OpenMPEG(mpeg_file, &img_info);  // open mpeg stream

  cout << "MPEG info:\n";
  cout << "Height = " << img_info.Height << endl;
  cout << "Width = " << img_info.Width << endl;
  cout << "Depth = " << img_info.Depth << endl;
  cout << "PixelSize = " << img_info.PixelSize << endl;
  cout << "Size = " << img_info.Size << endl;
  cout << "BitmapPad = " << img_info.BitmapPad << endl;
  cout << "PictureRate = " << img_info.PictureRate << endl;
  cout << "BitRate = " << img_info.BitRate << endl;
  cout << "ColormapSize = " << img_info.ColormapSize << endl;
  
  vimage.resize(img_info.Height, img_info.Width);

  win=new XWindow(con);

  // This gets the first frame into vimage

  forward();

  // Use this to set size

  set_size(vimage.height(),vimage.width());
    
  tracker_cleanup (this);
}

void 
MPEG::close() 
{
  CloseMPEG();  // close mpeg stream
}

//-----------------------------------------------------------------------------
//  Grab functions
//-----------------------------------------------------------------------------

int 
MPEG::forward() 
{
  char lname[200];

  int size = img_info.Size; // in bytes
  int pad_bytes = img_info.BitmapPad / 8; // bytes for "quantum" of scan line
  int pixel_bytes = img_info.PixelSize / 8; // bytes for each pixel
  int shift_bytes = pixel_bytes - 1;  // max bytes to shift
 
  unsigned char *imbuff = new unsigned char[size];

  // get the next mpeg frame
  if (!GetMPEGFrame((char *) imbuff)) {  // no more frames, rewind and loop
    RewindMPEG(mpeg_file, &img_info);
    GetMPEGFrame((char *)imbuff);
    frame_count = 1;
  }
  else {  // next frame
    frame_count++;
  }

  // store frame into image data
  int *p = vimage.data();

  for (int i = 0; i < size; i += pad_bytes) { // step by scan line quanta
    *p = 0;
    for (int j = 0; j < pixel_bytes; j++) { // fill int with pixel bytes
      *p += (imbuff[i+j] << ((shift_bytes - j-1) * 8));
    }
    p++;
  }

  delete imbuff;

  // Update the display
  construct_name(lname);

  win->show(vimage,lname);
  
  return 1;
}


//-----------------------------------------------------------------------------
//  Display functions
//-----------------------------------------------------------------------------

int 
MPEG::show (int x, int y,int width, int height, int *im) {
  
  if (!(in_view(x,y,width,height)))
    return 0;
  
  XVImage<int> image(ncols, nrows, im); 	// will worry about size later
  //   image.image=im;
  
  win->show(image);
  
  return 1;
}

//--------------------- For Drawing Pretty Pictures ------------

void 
MPEG::point (int x, int y, Color color, int size) 
{
  // !!! Needs to be written.
}


void 
MPEG::line (float x, float y, int length, float angle,
	    Color color, int samp) 
{
  win->line(int(x), int(y), length, angle, color);
}

void 
MPEG::circle (float x, float y, int r, Color color) 
{
  win->circle(int(x),int(y),r,color);
}

void 
MPEG::cubic (float x, float y, int length, float angle,
	     float a, float b, float c, Color color)
{
  // !!! Needs to be written.
}

//-----------------------------------------------------------------------------
