/*                                                                -*-c++-*-
    Copyright (C) 1996-1997 Gregory D. Hager, Kentaro Toyama (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  K2T_V300_Mono.hh
//
//  Declaration of the K2T_V300_Mono class.
//
//  03/15/95  Kentaro Toyama, after code for IT_FG101 by Sidd Puri.
//  02/07/97  Kentaro Toyama  (slight modifications, comments)
//
//-----------------------------------------------------------------------------

#ifndef K2T_V300_Mono_h
#define K2T_V300_Mono_h
#define _use_KTV_MONO_

#include "Tracker.hh"
#include "Video.hh"
#include "Tools.hh"

#include "ktv_basic.h"

//-----------------------------------------------------------------------------
//  Constant definitions
//-----------------------------------------------------------------------------

#define VIMAGE_SIZE 1024
int const KVM_xspin_offset = 0;  // Not really needed.

//-----------------------------------------------------------------------------
//  Class : K2T_V300_Mono
//
//* Derived from the MonoVideo class, this class allows monochrome image
//* grabs from the K2T_V300 framegrabber.  See comments for the Video 
//* class for details about derived functions not commented here.  
//*
//* WANTED: Someone to rewrite this so that oriented grabs are more
//* efficient. 
//-----------------------------------------------------------------------------

class K2T_V300_Mono: public MonoVideo {

  unsigned int *reg_map;     // Memory mapped locations of board registers
  unsigned int *mem_map;     // Memory mapped locations of framebuffer
  int *vimage;

protected:

  int map_color(Color colin) {
    switch(colin) {
    case default_color:
      return 2;

    case default_color2:
      return 1;

    case default_color3:
      return 3;

    case erase_color:
      return 0;

    default:
      return colin;
    }
  }

public:

  K2T_V300_Mono (int channel = 0,int camera = 0);     // initialize hardware
  ~K2T_V300_Mono() { }
  void close();
  char *device_info() { return "K2T V300 Monochrome"; };

  virtual void *current_frame_ptr() {return vimage;}

  // Image acquisition functions.

  //* Delegates calls to grab_aligned and grab_aligned_s when appropriate.
  //* Otherwise performs a dense initial grab of the bounding, aligned  //* rectangle (grab_aligned2), and THEN uses the routines from Acquire.*
  //* to grab an image with the desired orientation.  Very inefficient.
  int grab(int *image, int x, int y, int width, int height,
	    float angle = 0.0, int sampw =1 , int samph =1,
	    short int mask = 0xff);

  //* Optimized for dense grabs (i.e., no subsampling) of windows aligned
  //* with camera axes.  Due to the fact that whole words (4 bytes) are
  //* transfered over the bus to and from the framegrabber, and because
  //* the words are unpacked to make four ints each, some ugly code is
  //* required.  For some subsampled aligned grabs, grab_aligned_s (below)
  //* is faster.
  int grab_aligned(int *image, float &x, float &y,
		   int width, int height, int sampw =1, int samph =1,
		   short int mask = 0xff);

  int grab_aligned(int x, int y, int width, int height,
		    int *image, short int mask = 0xff);

  //* Used to pre-grab a bounding box around oriented grabs.  
  int grab_aligned2(int x, int y, int width, int height,
		    int *image, short int mask = 0xff);

  //* This version should be used to grab lines that are either subsampled
  //* in the y direction, subsampled with wsamp >= 4 in the x direction, or
  //* a combination.  
  int grab_aligned_s(int x, int y, int width, int height,
		    int *image, int wsamp, int lsamp, short int mask = 0xff);

  //* A vestigial function left over for some historical reason.  There
  //* shouldn't be a reason to use it.
  void grab_constant_size (int *image, float x, float y,		  
			   int width, int height,
			   float angle = 0.0, short int mask = 0xff);

  //* Currently does nothing.  The intention is to grab a single line
  //* of pixels at various orientations.
  void linegrab(int x, int y, int length,int *image, float angle, 
		short int mask = 0xff);

  //* Attempts to shows an image on the monitor.  However, because of timing
  //* problems (probably), little is actually visible on live output.
  int show (int x, int y, int width, int height, int *image);

  // Draw and clear a graphic overlay on the K2T_V300_Mono screen
  //   line:  endpoint and length
  //   line2:  two endpoints

  //* Draws a single point at (x,y) with color.
  void point (int x, int y, Color color = 1, int size=1);
 
  //* Draws a line using routines similar to those in Acquire.*
  void line (float x, float y, int length,   // draw an overlayed line
	     float angle,
	     int color = 1,int samp = 1);
  void clearline (float x, float y,	     // clear overlayed line
		  int length, float angle, int samp = 1);

  void line2 (float x1, float y1, float x2, float y2, 
	      int color = 1);
  void clearline2 (float x1, float y1, float x2, float y2);

  // Draw and clear a circle on the K2T_V300 screen

  //* Draws a square with sides = 2*radius, aligned with the camera axes.
  void circle (float x, float y, int r, int color = 1);
  void clearcircle(float x, float y,  int r);

  // Draw and clear a cubic-polynomial segment

  //* Draws nothing.  Do not use.
  void cubic (float x, float y, int length, float angle,
	      float a, float b, float c, int color = 1);
  void clearcubic (float x, float y, int length, float angle,
		   float a, float b, float c);

};

// include inline functions
#include "K2T_V300_Mono.icc"

//-----------------------------------------------------------------------------
#endif
