/*                                                                -*-c++-*-
    Copyright (C) 1995-1997 Gregory D. Hager, Kentaro Toyama (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  K2T_V300_Color.hh
//
//  Declaration of the K2T_V300_Color class.
//
//  03/15/95 Kentaro Toyama, after code for IT_FG101 by Sidd Puri.
//  01/??/97 Greg Hager, compatibility with new Video class.
//
//-----------------------------------------------------------------------------

#ifndef K2T_V300_Color_h
#define K2T_V300_Color_h
#define _use_KTV_MONO_

#include "Tracker.hh"
#include "Video.hh"
#include "Tools.hh"
#include "ktv_basic.h"

//-----------------------------------------------------------------------------
//  Constant definitions
//-----------------------------------------------------------------------------

#define VIMAGE_SIZE 1024
#define DEFAULT_COMPUTATION &compute_intensity;
int const KVH_xspin_offset = 0;		     // when x spin compensation is
					     // disabled, the grabbed image is
					     // 16 pixels to the right of the
					     // displayed image


//-----------------------------------------------------------------------------
//  Class : K2T_V300_Color
//
//* Derived from the ColorVideo class, this class allows color image
//* grabs from the K2T_V300 framegrabber.  See comments for the Video 
//* class for details about derived functions not commented here.  
//*
//* WANTED: Someone to rewrite this class so that oriented grabs are more
//* efficient. 
//
// !!! The entire structure of how the ColorVideo classes needs to be
// !!!   reconsidered.
//-----------------------------------------------------------------------------

class K2T_V300_Color: public ColorVideo {

  unsigned int *reg_map;     // Memory mapped locations of board registers
  unsigned int *mem_map;     // Memory mapped locations of framebuffer

  unsigned int *red_map;
  unsigned int *blu_map;
  unsigned int *grn_map;
  unsigned int *ovl_map;

  int *vimage;

protected:

  int map_color(Color colin) {
    switch(colin) {
    case default_color:
      return 2;

    case default_color2:
      return 1;

    case default_color3:
      return 3;

    case erase_color:
      return 0;

    default:
      return colin;
    }
  }

public:

  K2T_V300_Color (int channel = 0,int camera = 1);     // initialize hardware
  ~K2T_V300_Color() { }
  void close();

  //* Set RGB gains for K2T_V300 device.
  void set_gain (unsigned char r, unsigned char g, unsigned char b);

  virtual void *current_frame_ptr();

  // Image acquisition functions.

  //* Delegates calls to grab_aligned and grab_aligned_s when appropriate.
  //* Otherwise performs a dense initial grab of the bounding, aligned
  //* rectangle (grab_aligned2), and THEN uses the routines from Acquire.*
  //* to grab an image with the desired orientation.  Very inefficient.
  int grab(int *image, int x, int y, int width, int height,
	    float angle = 0.0, int sampw =1 , int samph =1,
	    short int mask = NOOVERLAY);

  //* Optimized for dense grabs (i.e., no subsampling) of windows aligned
  //* with camera axes.  Due to the fact that whole words (4 bytes) are
  //* transfered over the bus to and from the framegrabber, and because
  //* the words are unpacked to make four ints each, some ugly code is
  //* required.  For some subsampled aligned grabs, grab_aligned_s
  //* (below) is faster.
  int grab_aligned(int *image, float &x, float &y,
		   int width, int height, int sampw =1, int samph =1,
		   short int mask = 0xff);

  int grab_aligned(int x, int y, int width, int height,
		    int *image, short int mask = NOOVERLAY);

  //* Used to pre-grab a bounding box around oriented grabs.  
  int grab_aligned2(int x, int y, int width, int height,
		    int *image, short int mask = NOOVERLAY);

  //* This version should be used to grab lines that are either subsampled
  //* in the y direction, subsampled with wsamp >= 4 in the x direction, or
  //* a combination.  
  int grab_aligned_s(int x, int y, int width, int height,
		    int *image, int wsamp, int lsamp, 
		     short int mask = NOOVERLAY);

  //* A vestigial function left over for some historical reason.  There
  //* shouldn't be a reason to use it.
  void grab_constant_size (int *image, float x, float y,		  
			   int width, int height,
			   float angle = 0.0, short int mask = NOOVERLAY);

  //* Currently does nothing.  The intention is to grab a single line
  //* of pixels at various orientations.
  void linegrab(int x, int y, int length,int *image, float angle, 
		short int mask = NOOVERLAY);

  //* Attempts to shows an image on the monitor.  However, because of timing
  //* problems (probably), little is actually visible on live output.
  int show (int x, int y,
	     int width, int height,	     // show image 
	     int *image);

  // Draw and clear a graphic overlay on the K2T_V300 monitor
  //   line:  endpoint and length
  //   line2:  two endpoints

  //* Draws a single point at (x,y) with color.
  // !!! Shouldn't there be a non-pure virtual one of these in the Video 
  // !!!   class?
  void point (int x, int y, Color color = 1, int size=1);
 
  //* Draws a line using routines similar to those in Acquire.*
  void line (float x, float y, int length, float angle,
	     int color = 1,int samp = 1);
  void clearline (float x, float y, int length, float angle, int samp = 1);

  void line2 (float x1, float y1, float x2, float y2, int color = 1);
  void clearline2 (float x1, float y1, float x2, float y2);

  // Draw and clear a circle on the K2T_V300 screen

  //* Draws a square with sides = 2*radius, aligned with the camera axes.
  void circle (float x, float y, int r, int color = 1);
  void clearcircle(float x, float y,  int r);

  // Draw and clear a cubic-polynomial segment

  //* Draws nothing.  Do not use.
  void cubic (float x, float y, int length, float angle,
	      float a, float b, float c, int color = 1);
  void clearcubic (float x, float y, int length, float angle,
		   float a, float b, float c);

};

// include inline functions
#include "K2T_V300_Color.icc"

//-----------------------------------------------------------------------------
#endif

