/*                                                                -*-c++-*-
    Copyright (C) 1997-1997 Gregory D. Hager, Kentaro Toyama (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  K2T_V300_Color.cc
//
//  Definition of K2T_V300_Color class member functions.
//
//  03/15/95 Kentaro Toyama, after code for IT_FG101 by Sidd Puri
//  08/06/96 Greg Hager  Adapted to new Video class specifications
//
//-----------------------------------------------------------------------------

#include <site_config.h>
#ifdef  USE_K2T_COLOR 

#include <fcntl.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <stdlib.h>
#include <sys/file.h>
#include <unistd.h>
#ifndef __GNUC__
#include <strings.h>
#else
#include <string.h>
#endif

#include "Acquire.hh"
#include "K2T_V300_Color.hh"

extern "C" int gethostname(char *, int);

//-----------------------------------------------------------------------------
//  Constructor and destructor
//-----------------------------------------------------------------------------

// Creating a K2T_V300_Color device corresponds to initializing it
// and mapping the framegrabber memory.

K2T_V300_Color::K2T_V300_Color (int channel,int camera) :
  ColorVideo(4,KTV_DEFAULT_COLS,KTV_DEFAULT_ROWS)
{
  char buff[80];
  gethostname(buff,80); // could use this...
  printf ("K2T_V300 framegrabber and camera running on %s.\n",buff);

    vimage = new int[VIMAGE_SIZE*KTV_DEFAULT_ROWS];
  
    // Check to make sure parameters are legal
  
    if ((channel < 0) || (channel > 10))
      panic("Channel number out of range \n",false);
    if ((camera < 0) || (camera > 1))
      panic("Camera number out of range \n",false);
  
//    if (camera == 0) {
//      ktv_init_rgb(0,KTV_SYNCIN_SYNC);         // framegrabber syncs output
//    } else {
//      ktv_init_rgb(0,KTV_SYNCIN_GREEN);        // framegrabber syncs output
//    }
//    

    ktv_init_rgb(0,KTV_SYNCIN_SYNC);         // framegrabber syncs output

    red_map = (unsigned int *) KTV_RED;
    grn_map = (unsigned int *) KTV_GREEN;
    blu_map = (unsigned int *) KTV_BLUE;
    ovl_map = (unsigned int *) KTV_OV; 
    
    ktv_clear_ram(); 		              // Clear the display
    ktv_clear_overlay(); 	              // Clear the overlay planes
    ktv_live_mode();
    ktv_set_gain(128,128,128);                // Default gain settings

//---------
//    ktv_init_rgb(0,KTV_SYNCIN_SYNC);         // framegrabber syncs output
//    ktv_clear_ram(); 		               // Clear the display
//    ktv_clear_overlay(); 	               // Clear the overlay planes
//    ktv_live_mode();                         // Put board into live mode
//    ktv_set_gain(128,128,128);               // Default gain settings
//---------
    tracker_cleanup (this);
//   else {
//     printf ("Host %s does not have K2T_V300 framegrabber.  Exiting...\n",buff);
//     exit (1);
//   }

/*  comparr[0] = &compute_intensity;
  comparr[1] = &compute_hue;
  comparr[2] = &compute_saturation;
  comparr[3] = &compute_red;
  comparr[4] = &compute_green;
  comparr[5] = &compute_blue;
  comparr[6] = &compute_packed;
  comparr[7] = &compute_color;
  comparr[8] = &compute_woverlay;
  comparr[9] = &compute_other1;
  comparr[10] = &compute_other2;
  comparr[11] = &compute_other3;

  extract = comparr[channel];
*/
}

void K2T_V300_Color::close() {
}

//-----------------------------------------------------------------------------
//  Grab functions
//-----------------------------------------------------------------------------

// !!! This code really has to be replaced.
int K2T_V300_Color::grab (int *image, int x, int y, int width, int height, 
		  float angle, 
		  int sampw, int samph,
		  short int mask) {

  if (angle == 0.0)
    if ((sampw == 1) && (samph == 1)) 
      return grab_aligned(x,y,width,height,image,mask);
    else
      return grab_aligned_s(x,y,width,height,image,sampw,samph,mask);
  
  int new_width,new_height;

  aligned_envelope(width*sampw,height*samph,angle,&new_width,&new_height);
  if (compute_envelope)
    {
      envelope_height =  new_height;
      envelope_width  =  new_width;      
      envelope_x = x;      
      envelope_y = y;
      
      /* not working yet... 
         x1 = envelope_x - envelope_width/2
         x3 = x1         + envelope_width;
         y2 = envelope_y - envelope_height/2
         y4 = y2 + envelope_height;
         y3 = y4 - y1;
         y1 += y2;
         x4 = x3 - x1;
         x2 += x1;      
      */
      frames++;
    };      

  if (!(in_view(x,y,new_width,new_height)))
    return 0;

  grab_aligned2(x,y,new_width,new_height,vimage,mask);

  // Set up constants and map the desired window into the framebuffer
  // memory access window.  This scheme assumes that windows are
  // relatively square.

  angle = -angle;            
  x += KVH_xspin_offset;			     // set up constants
  
  if (sampw == 1) {
    if (samph == 1)
      UNIQNAM(rectangle)(vimage,image,x,y,angle,height,width,mask,1024);
    else
      UNIQNAM(rectangle_msh)(vimage,image,x,y,angle,height,width,samph,mask,1024);
  }
  else
    if (samph == 1)
      UNIQNAM(rectangle_msw)(vimage,image,x,y,angle,height,width,sampw,mask,1024);
    else
      UNIQNAM(rectangle_ms)(vimage,image,x,y,angle,height,width,samph,sampw,mask,1024);

  map_image(image,width*height);
  
  return 1;
}

int K2T_V300_Color::grab_aligned (int x, int y,
			  int width, int height, 
			  int *image, short int mask) {
  if (!in_view(x,y,width,height))
    return 0;

  x += KVH_xspin_offset;              // transform coordinates to corner
  int ix = x - (int) half (width);
  int iy = y - (int) half (height);

 if (compute_envelope)
    {
      x1 = -1;
      envelope_x = x;
      envelope_y = y;
      envelope_width = width;
      envelope_height = height;
      frames++;
    };



  register int row, col;
  register int word_offset, byte_offset;
  register unsigned int *impixel;
  unsigned int nextg, nextr, nextb;
  register unsigned int *ktv_pixelr, *ktv_pixelg, *ktv_pixelb;

  impixel = (unsigned int *) image;
  for (row = iy ; row < iy+height ; row++) {           // Handle each row 
    col = ix;
    // These are our starting points on the board - pointers to 32 bit words 
    ktv_pixelr = (unsigned int *) red_map + col/4 + row*256;
    ktv_pixelg = (unsigned int *) grn_map + col/4 + row*256;
    if (mask == WOVERLAY)
      ktv_pixelb = (unsigned int *) ovl_map + col/4 + row*256;
    else
      ktv_pixelb = (unsigned int *) blu_map + col/4 + row*256;
    impixel = (unsigned int *) image + col - ix + (row - iy) * width;
    // First few bytes may be done by hand 
    if (col%4) {
      byte_offset = ix%4;
      nextr = *ktv_pixelr++;
      nextg = *ktv_pixelg++;
      nextb = *ktv_pixelb++;
      while ( (byte_offset < 4) && (col < ix+width) ) {
        *impixel++ = compute_packed (((unsigned char *) (&nextr))[byte_offset],
				  ((unsigned char *) (&nextg))[byte_offset],
				  ((unsigned char *) (&nextb))[byte_offset]);
	byte_offset++;   col++;
      }
    }
    // Now we're on the next word boundary 
    while (col < (ix+width)-4) {
      nextr = *ktv_pixelr++;
      nextg = *ktv_pixelg++;
      nextb = *ktv_pixelb++;
      *impixel++ = compute_packed (((unsigned char *) (&nextr))[0],
				((unsigned char *) (&nextg))[0],
				((unsigned char *) (&nextb))[0]);
      *impixel++ = compute_packed (((unsigned char *) (&nextr))[1],
				((unsigned char *) (&nextg))[1],
				((unsigned char *) (&nextb))[1]);
      *impixel++ = compute_packed (((unsigned char *) (&nextr))[2],
				((unsigned char *) (&nextg))[2],
				((unsigned char *) (&nextb))[2]);
      *impixel++ = compute_packed (((unsigned char *) (&nextr))[3],
				((unsigned char *) (&nextg))[3],
				((unsigned char *) (&nextb))[3]);
      col += 4;
    }
    // Last word is also done "by hand" 
    if (col < ix+width) {
      byte_offset = 0;
      nextr = *ktv_pixelr++;
      nextg = *ktv_pixelg++;
      nextb = *ktv_pixelb++;
      while ( (byte_offset < 4) && (col < ix+width) ) {
        *impixel++ = compute_packed (((unsigned char *) (&nextr))[byte_offset],
				  ((unsigned char *) (&nextg))[byte_offset],
				  ((unsigned char *) (&nextb))[byte_offset]);
	byte_offset++;   col++;
      }
    }
  }

  map_image(image,width*height);
  
  return 1;
}

// !!! Are grab_aligned and grab_aligned2 the same?
int K2T_V300_Color::grab_aligned2 (int x, int y,
				  int width, int height, 
				  int *image, short int mask) {
  if (!in_view(x,y,width,height))
    return 0;
  
  x += KVH_xspin_offset;	         // transform coordinates to corner
  int ix = x - (int) half (width);
  int iy = y - (int) half (height);
  if (compute_envelope)
    {
      x1 = -1;
      envelope_x = x;
      envelope_y = y;
      envelope_width = width;
      envelope_height = height;
      frames++;
    };
  register int row, col;
  register int word_offset, byte_offset;
  register unsigned int *impixel;
  unsigned int nextg, nextr, nextb;
  register unsigned int *ktv_pixelr, *ktv_pixelg, *ktv_pixelb;
  
  impixel = (unsigned int *) image;
  for (row = iy ; row < iy+height ; row++) {           // Handle each row 
    col = ix;
    // These are our starting points on the board - pointers to 32 bit words 
    ktv_pixelr = (unsigned int *) red_map + col/4 + row*256;
    ktv_pixelg = (unsigned int *) grn_map + col/4 + row*256;
    if (mask == WOVERLAY)
      ktv_pixelb = (unsigned int *) ovl_map + col/4 + row*256;
    else
      ktv_pixelb = (unsigned int *) blu_map + col/4 + row*256;
    impixel = (unsigned int *) image + col + (row) * VIMAGE_SIZE;
    // First few bytes may be done by hand 
    if (col%4) {
      byte_offset = ix%4;
      nextr = *ktv_pixelr++;
      nextg = *ktv_pixelg++;
      nextb = *ktv_pixelb++;
      while ( (byte_offset < 4) && (col < ix+width) ) {
        *impixel++ = compute_packed (((unsigned char *) (&nextr))[byte_offset],
				  ((unsigned char *) (&nextg))[byte_offset],
				  ((unsigned char *) (&nextb))[byte_offset]);
	byte_offset++;   col++;
      }
    }
    // Now we're on the next word boundary 
    while (col < (ix+width)-4) {
      nextr = *ktv_pixelr++;
      nextg = *ktv_pixelg++;
      nextb = *ktv_pixelb++;
      *impixel++ = compute_packed (((unsigned char *) (&nextr))[0],
				((unsigned char *) (&nextg))[0],
				((unsigned char *) (&nextb))[0]);
      *impixel++ = compute_packed (((unsigned char *) (&nextr))[1],
				((unsigned char *) (&nextg))[1],
				((unsigned char *) (&nextb))[1]);
      *impixel++ = compute_packed (((unsigned char *) (&nextr))[2],
				((unsigned char *) (&nextg))[2],
				((unsigned char *) (&nextb))[2]);
      *impixel++ = compute_packed (((unsigned char *) (&nextr))[3],
				((unsigned char *) (&nextg))[3],
				((unsigned char *) (&nextb))[3]);
      col += 4;
    }
    // Last word is also done "by hand" 
    if (col < ix+width) {
      byte_offset = 0;
      nextr = *ktv_pixelr++;
      nextg = *ktv_pixelg++;
      nextb = *ktv_pixelb++;
      while ( (byte_offset < 4) && (col < ix+width) ) {
        *impixel++ = compute_packed (((unsigned char *) (&nextr))[byte_offset],
				  ((unsigned char *) (&nextg))[byte_offset],
				  ((unsigned char *) (&nextb))[byte_offset]);
	byte_offset++;   col++;
      }
    }
  }
  
  return 1;
}


// !!! What's the actual optimum?
int K2T_V300_Color::grab_aligned_s (int x, int y,
			  int width, int height, 
			  int *image, int wsamp, int lsamp, short int mask) {
  if (!in_view(x,y,width,height))
    return 0;

  x += KVH_xspin_offset;	        // transform coordinates to corner
  int ix = x - (int) half (width*wsamp);
  int iy = y - (int) half (height*lsamp);


  if (compute_envelope)
    {
      x1 = -1;
      envelope_x = x;
      envelope_y = y;
      envelope_width = width*wsamp;
      envelope_height = height*lsamp;
      frames++;
    };

  register int row, col;
  register int byte_offset;
  register unsigned int *impixel;
  register unsigned int *ktv_pixelr, *ktv_pixelg, *ktv_pixelb;
  unsigned int nextr, nextg, nextb;

  impixel = (unsigned int *) image;
  // Handle each row 
  for (row = iy ; row < iy+height*lsamp ; row += lsamp) {     
    byte_offset = row%4;
    for (col = ix; col < ix+width*wsamp ; col += wsamp) {
      // All bytes done by hand 
      ktv_pixelr = (unsigned int *) red_map + col/4 + row*256;
      ktv_pixelg = (unsigned int *) grn_map + col/4 + row*256;
      if (mask == WOVERLAY)
	ktv_pixelb = (unsigned int *) ovl_map + col/4 + row*256;
      else
	ktv_pixelb = (unsigned int *) blu_map + col/4 + row*256;
      nextr = *ktv_pixelr;                     // copy word to local
      nextg = *ktv_pixelg;                     // copy word to local
      nextb = *ktv_pixelb;                     // copy word to local
      *impixel++ = compute_packed (((unsigned char *) (&nextr))[byte_offset],
				((unsigned char *) (&nextg))[byte_offset],
				((unsigned char *) (&nextb))[byte_offset]);
    }
  }
  
  map_image(image,width*height);

  return 1;
}


// !!! Can we yank this?
void K2T_V300_Color::grab_constant_size (int *image,
				float x, float y, 
				int width, int height, 
				float angle, short int mask) {

  if (angle == 0) {
    grab_aligned(round(x),round(y),width, height, image, mask);
    return;
  } else {
    grab(image, round(x), round(y), width, height, angle, 1, 1, mask);
    return;
  }
}

// !!! Implement or kill.
void K2T_V300_Color::linegrab (int x, int y, int length,
		      int *image,float angle, short int mask) {
  x += KVH_xspin_offset;			     // set up constants

//  bham_line(mem_map,image, x,y,angle,length, mask, 1024);
    
}

//-----------------------------------------------------------------------------
//  Display functions
//-----------------------------------------------------------------------------

// !!! Needs to be fixed or eliminated.
int K2T_V300_Color::show (int x, int y,int width, int height, int *image) {
  if (!(in_view(x,y,width,height)))
    return 0;
  
  int nextwd;
  
  ktv_digitize_and_wait();

  for (int row = y+height-1; row >= y; row--) {
     for (int col = x+width-1; col >= x; col--) {
       nextwd = *(mem_map + row*256 + col/4);
       ((unsigned char *) (&nextwd))[col%4] = image[(row-y)*width+(col-x)];
       *(mem_map + row*256 + col/4) = nextwd;
     }
   }

  ktv_live_mode();

  return 1;
}

//--------------------- For Drawing Pretty Pictures ------------

void K2T_V300_Color::point (int x, int y, Color color, int size) {

  color = map_color(color);
  
  x += KVH_xspin_offset;

  extern int *KTV_OV;			/* Overlay band */

  int nextwd;

  int  ktv_pp_wd_off = y*256 + x/4;
  int  ktv_pp_bt_off = x%4;
  nextwd = *(KTV_OV + ktv_pp_wd_off);
  ((unsigned char *) (&nextwd))[ktv_pp_bt_off] = (color);
  *(KTV_OV + ktv_pp_wd_off) = nextwd;

}

// !!! We need to decide which version to use and stick with it.
void K2T_V300_Color::line (float x, float y, int length, float angle,
		     Color color, int samp) 
{
  color = map_color(color);

  if (in_view(x,y,(int)ceil(fabs(cos(angle))*length),
	          (int)ceil(fabs(sin(angle))*length))) 
    {
      x += KVH_xspin_offset;

      // K2Tdraw_line(int x,int y,float angle,int length,short int color) {
      //   a separate line-drawing function which can be removed if
      //   the more general template function works

      if ((color > 15) || (color < 0)) {color = 1;}  // red is the default
      unsigned char c = (unsigned char)color;
      int nypixels = (int)(fabs(((double)length)*sin(angle)) + 0.5);
      int nxpixels = (int)(fabs(((double)length)*cos(angle)) + 0.5);
      int low,high,alt,dir; double step,total=0.0;
      
      if (nxpixels>nypixels) {           // x-dominant
	dir = ( (tan(angle) >= 0) ? 1 : 0 );
	if (dir) {alt=y-nypixels/2;} else {alt=y+nypixels/2;}
	step = ((double)nypixels)/((double)nxpixels);
	low = x-nxpixels/2;  high = low+nxpixels;
	
	for (int pix=low ; pix<high ; pix++) {
	  ktv_put_overlay_pixel(&c,alt,pix);
	  total += step;
	  if (total>=1.0) {
	    total -= 1.0;
	    if (dir) {alt++;} else {alt--;}
	  }
	}
      } else {                           // y-dominant
	dir = ( (tan(angle) >= 0) ? 1 : 0 );
	if (dir) {alt=x-nxpixels/2;} else {alt=x+nxpixels/2;}
	step = ((double)nxpixels)/((double)nypixels);
	low = y-nypixels/2;  high = low+nypixels;
	
	for (int pix=low ; pix<high ; pix++) {
	  ktv_put_overlay_pixel(&c,pix,alt);
	  total += step;
	  if (total>=1.0) {
	    total -= 1.0;
	    if (dir) {alt++;} else {alt--;}
	  }
	}
      }
  
      // }  end of the ad hoc line-drawing function
      //
      //    This is the old line drawing function -- the code is in
      //      Drawing.cc.template
      //
      //     short int colr = color << 8;	     // turn color into overlay
      //     
      //     int maxside = ((samp*length) >> 1) + 1;
      //     
      //     int xoff = max2(0,round(x)-maxside);
      //     int yoff = max2(0,round(y)-maxside);
      //     x-=xoff;
      //     y-=yoff;
    
      //    UNIQNAM(draw_line)((unsigned int *)mem_map,(int)x,
      //                       (int)y,angle,length,(short int)color,samp,1024);
  }
}

void K2T_V300_Color::line2 (float x1, float y1, float x2, float y2, Color color){
  double angle = atan2(y2-y1,x2-x1);
  double length = sqrt (sqr (y2-y1) + sqr (x2-x1));
  line ((x2+x1)/2.0, (y2+y1)/2.0, length, angle, color, 1);
}

void K2T_V300_Color::circle (float x, float y, int r, Color color) {
  line (x,y-r,r*2,0.0,color);
  line (x,y+r,r*2,0.0,color);
  line (x-r,y,r*2,M_PI_2,color);
  line (x+r,y,r*2,M_PI_2,color);
}

void K2T_V300_Color::cubic (float x, float y, int length, float angle,
		   float a, float b, float c, Color color)
{
}

// !!! Why is this here?
#undef PIXEL

//-----------------------------------------------------------------------------


#endif // USE_K2T_COLOR 
