/*                                                                -*-c++-*-
    Copyright (C) 1994-1997 Gregory D. Hager (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  IndyCam_Mono.hh
//
//  Specification of the IndyCam class, which provides an interface between
//  tracking software and IndyCam hardware.
//
//  07/06/94 Greg Hager
//  ??/??/96 Greg Hager various improvements.
//
//-----------------------------------------------------------------------------

#ifndef IndyCam_Mono_h
#define IndyCam_Mono_h

extern "C" {
#include <vl/vl.h>
}

#define BUILT_IN 0
#define GALILEO  1

#include "Video.hh"

//-----------------------------------------------------------------------------
//   Class : IndyCam_Mono
//
//*  The class allows access to any of the RGB channels, or a luminance
//*  value computed from them.  The type of information is specified when
//*  the variable is created.  Multiple instances of this class can be
//*  created.  They all share a common window, but can access different
//*  fields of the image.
//*
//*  This class can probably be improved in speed by constructing a more
//*  direct connection between the framegrabber and the monitor.  Also
//*  this class uses frames in a nonstandard way: a data pointer to 
//*  released frames is maintained although the frame is again in use
//*  by the framegrabber.
//-----------------------------------------------------------------------------

class IndyCam_Mono : public MonoVideo {
  
  // The following variables are declared statically so that multiple
  // instances of the video class can share the same image if, for 
  // for example, there are multiple cameras hooked up as a single color
  // image.  Right now this isn't quite what it should be since
  // all of the images are shown in the same window.
  
  static VLServer svr;
  static VLPath path;
  static VLNode src, drn;
  static VLBuffer buffer;
  static ulong *dataPtr;
  static int ninstances;
  static long win;    
  
  static int gotfirst;
  
  int info_type;
  
  //* Transfer a new image, if a new image has been grabbed by 
  //* the framegrabber.
  // !!! Is this the right comment?
  VLInfoPtr checknew();
  void error_exit(char *mess = NULL);
  
  int map_color(Color x);
  void set_color(Color x);
  
  int stopped;
public:
  
  IndyCam_Mono (int analog = 0);
  ~IndyCam_Mono();
  void close();
  
  long window();
  
  // In the Indy's case, this handles getting new images in the
  // ring buffer.
  
  virtual int pre_grab();
  
  //* This is a hack that allows stopping of live grabs.  
  // !!! Should this be in generic interface?
  virtual int stop_live();
  virtual int start_live();
  
  virtual void *current_frame_ptr();
  
  // Show an image on the IndyCam_Mono screen at the specified location
  // with the specified height and width.
  
  int show (int x, int y, int width, int height, int *image);
  
  // Draw and clear a graphic overlay on the IndyCam_Mono screen
  //   line:  endpoint and length
  //   line2:  two endpoints
  
  void line (float x, float y, int length, float angle,
	     Color color = default_color,int samp = 1);
  void line2 (float x1, float y1, float x2, float y2, 
	      int color = default_color);
  
  // Draw and clear a circle on the IndyCam_Mono screen
  
  void circle (float x, float y, int r, 
	       int color = default_color);
  void clearcircle(float x, float y,  int r);
  
  // Draw and clear a cubic-polynomial segment
  
  void cubic (float x, float y, int length, float angle,
	      float a, float b, float c, 
	      int color = default_color);
  void clearcubic (float x, float y, int length, float angle,
		   float a, float b, float c);
  
};

// include inline functions
#include "IndyCam_Mono.icc"

#endif

