/*                                                                -*-c++-*-
    Copyright (C) 1994-1997 Gregory D. Hager (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  IndyCam_Color.cc
//
//  Definition of IndyCam_Color member functions.
//
//  07/06/94 Greg Hager
//  ??/??/96 Greg Hager various improvements.
//
//-----------------------------------------------------------------------------

#include <site_config.h>
#ifdef USE_INDYCAM_COLOR

#include <stdlib.h>

#include "Video.hh"
#include "Acquire.hh"
#include "IndyCam_Color.hh"

extern "C" {
#include <gl/gl.h>
#include <dmedia/vl_vino.h>
}

VLServer IndyCam_Color::svr = NULL;
VLPath IndyCam_Color::path;
VLNode IndyCam_Color::src, IndyCam_Color::drn;
VLBuffer IndyCam_Color::buffer;
ulong *IndyCam_Color::dataPtr;
int IndyCam_Color::ninstances;
long IndyCam_Color::win;
int IndyCam_Color::gotfirst = 0;


void IndyCam_Color::error_exit(char *mess) 
{
  if (mess != NULL) 
    cerr << mess << endl;
  else
    cerr << "Some problem with the IndyCam_Color setup" << endl;
  exit(1);
}


IndyCam_Color::IndyCam_Color(int analog) : 
ColorVideo(4,640,480) 
{
  
  VLControlValue val;
  
  ninstances++;
  
  foreground();
  
  // There is supposed to be a color mode, but I've never seen it work
  
  set_input_type(PIX_PACKED);
  
  // The first instance opens up the camera and gets things set.
  
  if (ninstances == 1) {
    
    // Connect to the daemon 
    if (svr == NULL)
      if (!(svr = vlOpenVideo(""))) {
	cerr << "Unable to open IndyCam_Color Server" << endl;
	exit(1);
      }
    
    // Set up a drain node in memory 
    drn = vlGetNode(svr, VL_DRN, VL_MEM, VL_ANY);
    
    // Set up a source node on any video source  
    
    /*
    if (analog)
      src = vlGetNode(svr, VL_SRC, VL_VIDEO, VL_VINO_SRC_AV_IN);
    else
      src = vlGetNode(svr, VL_SRC, VL_VIDEO, VL_VINO_SRC_DV_IN);
    */

	src = vlGetNode(svr, VL_SRC, VL_VIDEO, VL_ANY);

    // Create a path using the first device that will support it 
    path = vlCreatePath(svr, BUILT_IN, src, drn); 
    
    // Set up the hardware for and define the usage of the path 
    if ((vlSetupPaths(svr, (VLPathList)&path, 1,
		      VL_SHARE, VL_SHARE)) < 0)
      error_exit();
    
    // Set color/colorchrome  (this call is not accepted by the VINO)
    // /*
    //       val.intVal = VL_VINO_COLOR_MODE_COLOR;
    //       if (vlSetControl(svr, path, src, VL_VINO_COLOR_MODE, &val) < 0) {
    // 	vlPerror("Setting mode: ");
    // 	error_exit();
    //       }*/
    
    // Set the packing to RGB 
    
    val.intVal = VL_PACKING_RGB_8;
    if (vlSetControl(svr, path, drn, VL_PACKING, &val) < 0) {
      vlPerror("Setting Packing: ");
      error_exit();
    }
    
    // Set up nonlinterleaved capture 
    // /*      val.intVal = VL_CAPTURE_NONINTERLEAVED;
    //       if (vlSetControl(svr, path, drn, VL_CAP_TYPE, &val) < 0) {
    // 	vlPerror("Setting interlace: ");
    // 	error_exit();
    //       }
    // */
    // Set slow capture 
    //val.intVal = 15;
    //if (vlSetControl(svr, path, src, VL_RATE, &val) < 0) {
    //  vlPerror("Setting rate: ");
    //  error_exit();
    //}
    
    
    // Set slow shutter 
    // /*
    //       val.intVal = VL_VINO_IndyCam_Color_SHUTTER_60;
    //       if (vlSetControl(svr, path, src, VL_VINO_IndyCam_Color_SHUTTER, &val) < 0) {
    // 	vlPerror("Setting shutter: ");
    // 	error_exit();
    //       }
    // */
    // Get the video size 
    vlGetControl(svr, path, drn, VL_SIZE, &val);
    
    ncols = val.xyVal.x;
    nrows = val.xyVal.y;
    
    // Set up and open a GL window to display the data 
    prefsize(width(),height());
    win = winopen("Tracking Window");
    RGBmode();
    RGBcolor(0,100,200);
    pixmode(PM_TTOB, 1);
    gconfig();
    
    // Create and register a buffer for 1 frame 
    buffer = vlCreateBuffer(svr, path, drn, 1);
    if (buffer == NULL)
      error_exit();	
    vlRegisterBuffer(svr, path, drn, buffer);
    
    // Begin the data transfer 
    if (vlBeginTransfer(svr, path, 0, NULL))
      error_exit();
    
    dataPtr = NULL;
  }
}


void
IndyCam_Color::close() 
{
  
  ninstances --;
  if (ninstances == 0) {
    vlEndTransfer(svr, path);
    
    vlDeregisterBuffer(svr, path, drn, buffer);
    vlDestroyBuffer(svr, buffer);
    vlDestroyPath(svr, path);
    vlCloseVideo(svr);
  }
}


VLInfoPtr
IndyCam_Color::checknew()
{
  VLInfoPtr info;
  
  info = vlGetNextValid(svr, buffer);
  
  if (info != NULL) {
    
    // Get a pointer to the frame 
    dataPtr = (ulong *)vlGetActiveRegion(svr, buffer, info);
    
    // Write the data to the screen 
    
    winset(win);
    lrectwrite(0,0, width()-1, height()-1, (ulong *)dataPtr);
    
    // Finished with frame, unlock the buffer 
    vlPutFree(svr, buffer);
  }
  
  return info;
}


int
IndyCam_Color::pre_grab() 
{
  
  checknew();
  
  if (!gotfirst) {
    while (dataPtr == NULL)
      checknew();
    gotfirst = 1;
  }
  
  if (dataPtr == NULL)
    return 0;
  else
    return 1;
}

void
IndyCam_Color::set_color(Color x) 
{
  int y = map_color(x);
  char *xx = (char *)(&y);
  RGBcolor(xx[0],xx[1],xx[2]);
}

// !!! Major hack.
int
IndyCam_Color::map_color(Color x) 
{
  int temp = 0;
  char *rptr = ((char *)&temp);
  char *gptr = ((char *)&temp)+1;
  char *bptr = ((char *)&temp)+2;
  
  //  cout << "Color is " << x << endl;
  
  switch (x) {
  case no_color:
    return 0;
    break;
    
  case green_color:
    *gptr = 255;
    break;
    
  case red_color:     
    *rptr = 255;
    break;
    
  case blue_color:    
    *bptr = 255;
    break;
    
  case yellow_color:
    *gptr = 100;
    *bptr = 100;
    break;
    
  case purple_color:
    *rptr = 100;
    *bptr = 100;
    break;
    
  case cyan_color:    
    *gptr = 100;
    *rptr = 100;
    break;
    
  case white_color:   
    *rptr = *gptr = *bptr = 255;
    break;
    
  case black_color:
    break;
    
  default:
    temp = (int )x;
    break;
    
  }
  
  return temp;
}


int
IndyCam_Color::show (int x, int y, int width, int height, int *image)
{
  
  winset(win);
  //   pixmode(PM_INPUT_FORMAT,PM_LUMINANCE);
  lrectwrite(x,this->height()-y-height,
	     x+width-1,this->height()-y-1,
	     (ulong *)image);
  return 1;
}

void
IndyCam_Color::line (float x, float y, int length, float angle,
		     Color color,int samp)
{
  
  if (in_view(x,y,
	      ceil(cos(angle)*length),
	      ceil(sin(angle)*length))) {
    
    length/=2.0;
    float vec[2];
    
    winset(win);
    set_color(color);
    bgnline();
    vec[0] = x-cos(angle)*length;
    vec[1] = height()- (y-sin(angle)*length);
    v2f(vec);
    vec[0] = x+cos(angle)*length;
    vec[1] = height() - (y+sin(angle)*length);
    v2f(vec);
    endline();
  }
}

void
IndyCam_Color::line2 (float x1, float y1, float x2, float y2, int color)
{
  float vec[2];
  winset(win);
  set_color(color);
  bgnline();
  vec[0] = x1; vec[1] = height()-y1;
  v2f(vec);
  vec[0] = x2; vec[1] = height()-y2;
  v2f(vec);
  endline();
  
}


#endif // USE_INDYCAM_COLOR
