#ifndef Ieee1394_h
#define Ieee1394_h

#include <sys/types.h>
#include <video1394.h>
#include <libraw1394/raw1394.h>
#include "dc1394_control.h"
#include "Video.hh"

#define DC_DEVICE_NAME  "/dev/video1394"
#define DIG_DEF_NUMFRAMES 4

typedef struct
{
     char c;                      // parameter specification e.g. B
     int  val;                    // assigned value
}XVParser; 

class Ieee1394 : public ColorVideo {
  static int  ninstances;
  static int  gotfirst;
  static int  fd;
  static int  node_id;
  static int  buffer_id;
  static int  scale;
  static int  scheduled;
  static int  raw_rgb;
  static int  brightness;
  static ulong *dataPtr;
  static raw1394handle_t       handle;
  static unsigned char         *mm_buf[DIG_DEF_NUMFRAMES];
  static unsigned char         *image_buffers[DIG_DEF_NUMFRAMES];
  static dc1394_cameracapture camera; 
  static nodeid_t * camera_nodes;
  static int n_buffers;
  struct video1394_mmap v_mmap; 
  int    yuv422torgb (unsigned char *YUV, unsigned char * targ, int NumPixels);
  int    rawtorgb (unsigned char *YUV, u_char * targ, int NumPixels);
  int map_color(Color x);
  void set_color(Color x);
  void error_exit(char *mesg);
  int parse_param(char * &paramstring, XVParser &result);
  int checknew(void);
  
public:
  
  Ieee1394 (char *paramstring);
  ~Ieee1394();
  int open (const char *);
  void close();
  
  long window();
  
  // In the Indy's case, this handles getting new images in the
  // ring buffer.
  int set_params(char *paramstring);
  
  virtual int pre_grab();
  
  
  virtual void *current_frame_ptr(void);
  // No display capabilities

  virtual int show (int x, int y,
		    int width, int height,	     // show image 
		    int *image) {return 0;};

  virtual void line (float x, float y, int length, float angle,
		     Color color = default_color,int samp = 1) {};


};

// include inline functions
#include "Ieee1394.icc"

#endif

