/*                                                                -*-c++-*-
    Copyright (C) 1996-1997 Gregory D. Hager and Sidd Puri (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  IT_icpcia.hh
//
//  Declaration of the IT_icpcia class.
//
//  07/17/96 Greg Hager
//
//-----------------------------------------------------------------------------

#ifndef IT_icpci_h
#define IT_icpci_h

#include <stdlib.h>
#include <errno.h>
#include <unistd.h>

#include "Tracker.hh"
#include "Video.hh"
#include "Tools.hh"

extern "C" {
#include        <it_ic_pci.h>
#include        <it_ic_pci_lib.h>
}

//-----------------------------------------------------------------------------
//   Class : IT_icpci 
//
//*  Declaration of the IT_icpcia class, which provides an interface between
//*  tracking software and IT_icpcia hardware.   The current interface
//*  uses straight memory mapping of the device.  The images acquired
//*  are not deinterlaced, so this driver is set up to run at half 
//*  resolution on a single field of data.  It requires the kernal
//*  module it_ic_pci to be installed.  See "init_script" in 
//*  the bin directory for directions on how to install this driver.
//-----------------------------------------------------------------------------

class IT_icpci: public ColorVideo {

  unsigned short *regbase;    // Memory mapped locations of board registers
  unsigned long *membase;     // Memory mapped locations of framebuffer
  it_ic_pci_info_t *fb_info;

protected:

  int map_color(Color colin);

public:

  IT_icpci (short camport = 2);     // initialize hardware
  ~IT_icpci(); 
  void close();

  char *device_info();

  // Acquire a rectangle of data at an angle.

  virtual int grab(int *image, int x, int y, int width, int height,
		   float angle = 0.0, int sampw =1 , int samph =1,
		   short int mask = 0xff);


  virtual int grab_aligned(int *image, float &x, float &y, 
			   int width, int height, int wsamp, int lsamp, 
			   short int mask = 0xff);

  // Acquiring a single line of pixels.  Same conventions as above.
  void linegrab(int x, int y, int length,int *image, float angle, 
		short int mask = 0xff);

  // Show an image on the IT_icpci screen at the specified location
  // with the specified height and width.
  int show (int x, int y, int width, int height, int* image);

  // Draw and clear a graphic color on the IT_icpci screen
  //   line:  endpoint and length
  //   line2:  two endpoints

  void line (float x, float y, int length, float angle,
	     int color = green_color,int samp = 1);
  void clearline (float x, float y, int length, float angle, int samp = 1);

  void line2 (float x1, float y1, float x2, float y2, 
	      int color = green_color);
  void clearline2 (float x1, float y1, float x2, float y2);

  void square (float x, float y, int r, int color = green_color);

  // Draw and clear a circle on the IT_icpci screen

  void circle (float x, float y, int r, int color = green_color);
  void clearcircle(float x, float y,  int r);

  // Draw and clear a cubic-polynomial segment

  void cubic (float x, float y, int length, float angle,
	      float a, float b, float c, int color = green_color);
  void clearcubic (float x, float y, int length, float angle,
		   float a, float b, float c);

};

// include inline functions
#include "IT_icpci.icc"

//-----------------------------------------------------------------------------
#endif
