/*                                                                -*-c++-*-
    Copyright (C) 1996-1997 Gregory D. Hager and Sidd Puri (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  IT_icpci.cc
//
//  Definition of Video class member functions.
//
//  07/19/96 Greg Hager
//
//-----------------------------------------------------------------------------

#include <site_config.h>
#ifdef  USE_IT_ICPCI

#include <fcntl.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <sys/file.h>
#include <strings.h>
#include <unistd.h>

//#include "Acquire.hh"
#include "Video.hh"
#include "IT_icpci.hh"

// The following redefinitions are here only because we
// are running the device in half-resolution right now.

#define UNIQNAM(base) icpci_bham_##base
#define PIXEL(mem,loc,mask) (mem[loc<<1])
#include "Acquire.cc.template"

// Acquire a rectangle of data oriented to fit the framegrabber.
// !!! Should this be in DeviceTools.cc?
inline 
int 
adjust(float &x,int width) 
{
  // If odd, adjust to nearest whole coordinate, otherwise, nearest
  // half and return the beginning index

  if (odd(width)) {
    x = round(x);
    return x - width/2;
  }
  else {
    x = (int)x + 0.5;
    return (int)x - width/2 + 1;
  }
}

//-----------------------------------------------------------------------------
//  Constructor and destructor
//-----------------------------------------------------------------------------

IT_icpci::IT_icpci (short camport) : 
ColorVideo(0,0)
{
  char buff[80];

  short width = 512,height = 512;

  // Check to make sure parameters are legal
  
  if ((camport < 0) || (camport > 3))
    panic("Camera number out of range \n",false);


  // find board and get it open 
   
  if ((fb_info = it_ic_pci_open(0) ) == NULL)
    panic("Can't open driver.  Have you run 'init_script' in the bin directory? \n");

  membase = (unsigned long int *)fb_info ->memory_log_addresses[0];

  printf("Memory base is %lx \n",membase);

  // Set the video device size
  // RIGHT SHIFT BECAUSE OF DRIVER PROBLEMS

  set_size(fb_info->height>>1,fb_info->width>>1);
  
  printf("Initialization finished; starting grab. \n");

  it_ic_pci_grab(fb_info);

  // And now go for it

  tracker_cleanup (this);
}

void
IT_icpci::close() 
{
}


//-----------------------------------------------------------------------------
//  Refresh functions
//-----------------------------------------------------------------------------

int
IT_icpci::grab_aligned (int *image, float &x, float &y,
			int width, int height,
			int sampw, int samph, short int mask) 
{
  if (!in_view(x,y,width,height))
    return 0;

  int i,j;
  int fx,fy;

  if (!(in_view(x,y,width*sampw,height*samph)))
    return 0;

  // SHIFT BECAUSE OF DRIVER PROBLEMS

  sampw <<= 1;
  float tx = x*2;
  fx = adjust(tx,width*sampw);
  fy = adjust(y,height*samph);
  x = tx/2;

  // THIS IS BECAUSE OF DRIVER PROBLEMS

  if (sampw == 1) {
    for (i=0;i<height;i++)
      memcpy(image+i*width ,membase+(fy+i*samph)*ncols+fx,
	     width*(sizeof(int)));
  }
  else {
    int rwidth = width*sampw;
    int *limage = image;
    
    // SHIFT BECAUSE OF DRIVER PORBLEMS
    ulong *ldata = membase + fy*(ncols<< 1)+fx;
    for(i=0;i<height;i++) {
      for(j=0;j<rwidth;j+=sampw)
	*limage++ = ldata[j];

      // SHIFT BECAUSE OF DRIVER PROBLEMS 
      ldata+= (ncols << 1)*samph;
    }
  }

  map_image(image,width*height);

  return 1;
}

//-----------------------------------------------------------------------------

int
IT_icpci::grab (int *image, int x, int y, int width, int height, 
		float angle, int sampw, int samph, short int mask) 
{

  if (angle == 0.0) 
     return grab_aligned(image,x,y,width,height,sampw,samph,mask);

  if (!(in_view(x,y,width*sampw,height*samph,angle)))
    return 0;

  // Set up constants and map the desired window into the framebuffer
  // memory access window.  This scheme assumes that windows are
  // relatively square.

  angle = -angle;            

  if (sampw == 1) {
    if (samph == 1)
      icpci_bham_rectangle(membase,image,x,y,angle,height,width,mask,ncols);
    else
      icpci_bham_rectangle_msh(membase,image,x,y,angle,height,width,
			       samph,mask,ncols);
  }
  else
    if (samph == 1)
      icpci_bham_rectangle_msw(membase,image,x,y,angle,height,width,
			       sampw,mask,ncols);
    else
      icpci_bham_rectangle_ms(membase,image,x,y,angle,height,width,
			      samph,sampw,mask,ncols);


  map_image(image,width*height);

  return 1;
}


void
IT_icpci::linegrab (int x, int y, int length,
		      int *image,float angle, short int mask) 
{
  icpci_bham_line(membase,image, x,y,angle,length, mask, 1024);
    
}

//-----------------------------------------------------------------------------
//  Display functions
//-----------------------------------------------------------------------------


int
IT_icpci::show (int x, int y,int width, int height, int *image) 
{
  // !!! Needs to be written.
}

//--------------------- For Drawing Pretty Pictures ------------

void 
IT_icpci::line (float x, float y, int length, float angle,
		Color color, int samp) 
{
  // !!! Needs to be written.
}

void IT_icpci::line2 (float x1, float y1, float x2, float y2, Color color) 
{
  // !!! Needs to be written.
}

void IT_icpci::square (float x, float y, int r, Color color) 
{
  // !!! Needed at all?
}

void IT_icpci::circle (float x, float y, int r, Color color) 
{
  // !!! Needs to be written.
}

void IT_icpci::cubic (float x, float y, int length, float angle,
		   float a, float b, float c, Color color)
{
  // !!! Needs to be written.
}

//-----------------------------------------------------------------------------

#endif // USE_IT_ICPCI
