/*                                                                -*-c++-*-
    Copyright (C) 1993-1997 Gregory D. Hager and Sidd Puri (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  IT_FG101.sunos.hh
//
//  Declaration of the IT_FG101 class, for SUNOS.
//
//  06/06/93 Sidd Puri
//
// !!! This version is not compatible with v. 1.2+.  Should be merged with
// !!!   IT_FG101.solaris.* .  Discard IT_FG101.?? .
//-----------------------------------------------------------------------------

#ifndef IT_FG101_h
#define IT_FG101_h

#include "Tracker.hh"
#include "Video.hh"
#include "Tools.hh"

#include "/local/include/itex100.h"
#include "/local/include/IT_framebuffer.h"

//-----------------------------------------------------------------------------
//  Definitions from /local/src/IT/100/include/stdtyp.h
//-----------------------------------------------------------------------------

typedef unsigned char		BYTE;
typedef short int		WORD;
typedef unsigned short int	UWORD;
typedef int			LONG;
typedef unsigned int		ULONG;

//-----------------------------------------------------------------------------
//  External C function declarations
//-----------------------------------------------------------------------------

extern "C" {

// Functions from Chapter 2 of documentation.

  void sethdw (unsigned int regbase, LONG membase, int flag, int memory);
  void setdim (int xsize, int ysize, int depth);
  void initialize();
  ULONG delta_ms();

// Functions from Chapter 3

//  void setreg (unsigned int offset, unsigned int newval);
  unsigned int getreg (unsigned int offset);
  void andreg (unsigned int offset, unsigned int andval);
  void orreg  (unsigned int offset, unsigned int orvar);
  unsigned int testreg (unsigned int offset, unsigned int maskval);

// Functions from Chapter 4

  void setvmask (unsigned int mask);
  void setpmask (unsigned int mask);
  unsigned int getpmask();
  void setcamera (int n);
  void snap (int waitflag);
  void grab (int count);
  void stopgrab (int waitflag);
  void aclear (int x, int y, int dx, int dy, int value);
  void sclear (int value);

// Functions from Chapter 5

  void whline (int x, int y, int n, int *pixarray);
  void rhline (int x, int y, int n, int *pixarray);

// Functions from Chapter 6

  void dynamic_luts();

// Functions from Chapter 12

  void line (int x1, int y1, int x2, int y2, int value);
  int circle (int, int, int, int, int, int);
}

// Undocumented global variables used by it100 routines to hold addresses of
// memory-mapped registers and frame buffer

extern unsigned short *reg_map;
extern unsigned short *mem_map;

//-----------------------------------------------------------------------------
//  Constant definitions
//-----------------------------------------------------------------------------

int const IT_xspin_offset = 16;		     // when x spin compensation is
					     // disabled, the grabbed image is
					     // 16 pixels to the right of the
					     // displayed image

//-----------------------------------------------------------------------------
//  IT_FG101 class declaration
//-----------------------------------------------------------------------------

class IT_FG101: public Video {

  unsigned short *reg_map;     // Memory mapped locations of board registers
  unsigned short *mem_map;     // Memory mapped locations of framebuffer

  void sethdw();

  // Register operations that use local memory addresses

  void setreg (unsigned short offset, unsigned short newval);
  unsigned short getreg (unsigned short offset);

  int grab_aligned(int x, int y, int width, int height,
		    int *image, short int mask = 0xff);

protected:

  int map_color(Color colin);

public:

  IT_FG101 (int channel = 0,int camera = 0);     // initialize hardware
  ~IT_FG101();
  void close();
  char *device_info();

  // Grab functions.

  int grab(int *image, int x, int y, int width, int height,
	    float angle = 0.0, int sampw =1 , int samph =1,
	    short int mask = 0xff);

  void grab_constant_size (int *image, float x, float y,		  
			   int width, int height,
			   float angle = 0.0, short int mask = 0xff);

  // Acquiring a single line of pixels.

  void linegrab(int x, int y, int length,int *image, float angle, 
		short int mask = 0xff);

  // Show an image on the IT_FG101 screen at the specified location
  // with the specified height and width.

  int show (int x, int y, int width, int height, int* image);

  // Draw and clear a graphic overlay on the IT_FG101 screen
  //   line:  endpoint and length
  //   line2:  two endpoints

  void line (float x, float y, int length,   // draw an overlayed line
	     float angle, int color = GREEN_OVERLAY,int samp = 1);
  void clearline (float x, float y,	     // clear overlayed line
		  int length, float angle, int samp = 1);

  void line2 (float x1, float y1, float x2, float y2, 
	      int color = GREEN_OVERLAY);
  void clearline2 (float x1, float y1, float x2, float y2);

  void square (float x, float y, int r, int color = GREEN_OVERLAY);

  // Draw and clear a circle on the IT_FG101 screen

  void circle (float x, float y, int r, int color = GREEN_OVERLAY);
  void clearcircle(float x, float y,  int r);

  // Draw and clear a cubic-polynomial segment

  void cubic (float x, float y, int length, float angle,
	      float a, float b, float c, int color = GREEN_OVERLAY);
  void clearcubic (float x, float y, int length, float angle,
		   float a, float b, float c);

  // Some overlays for functions that do the appropriate memory
  // address switching before calling the function

  void sclear (int value);
  void snap (int waitflag);
  void stopgrab (int waitflag);
  void setvmask(unsigned short mask);
  void setpmask(unsigned short mask);
  unsigned short getpmask();

};

// include inline functions
#include "IT_FG101.sunos.icc"

//-----------------------------------------------------------------------------
#endif


