/*                                                                -*-c++-*-
    Copyright (C) 1993 Gregory D. Hager and Sidd Puri (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  IT_FG101.solaris.hh
//
//  Declaration of the IT_FG101 class, for Sun Solaris OS's.
//
//  06/06/93 Sidd Puri
//  ??/??/96 Greg Hager
//
//-----------------------------------------------------------------------------

#ifndef IT_FG101_h
#define IT_FG101_h

#include <stdlib.h>
#include <errno.h>
#include <unistd.h>

#include "Tracker.hh"
#include "Video.hh"
#include "Tools.hh"

#include "/local/include/itex100.h"
#include "/local/include/IT_framebuffer.h"

//-----------------------------------------------------------------------------
//  Definitions from /local/src/IT/100/include/stdtyp.h
//-----------------------------------------------------------------------------

typedef unsigned char		BYTE;
typedef short int		WORD;
typedef unsigned short int	UWORD;
typedef int			LONG;
typedef unsigned int		ULONG;

//-----------------------------------------------------------------------------
//  Constant definitions
//-----------------------------------------------------------------------------

int const IT_xspin_offset = 16;		     // when x spin compensation is
					     // disabled, the grabbed image is
					     // 16 pixels to the right of the
					     // displayed image

//-----------------------------------------------------------------------------
//  IT_FG101 class declaration
//-----------------------------------------------------------------------------

class IT_FG101: public Video {

  int fd,fd1;

  unsigned short *reg_map;     // Memory mapped locations of board registers
  unsigned short *mem_map;     // Memory mapped locations of framebuffer

  void sethdw();

  // Register operations that use local memory addresses

  void setreg (unsigned short offset, unsigned short newval);
  void andreg (unsigned short offset, unsigned short newval);
  void orreg (unsigned short offset, unsigned short newval);
  unsigned short getreg (unsigned short offset);
  void setcamera(unsigned short channel);
  void dynamic_luts();
  void grab();
  void stopgrab();

  int grab_aligned(int x, int y, int width, int height,
		    int *image, short int mask = 0xff);
  int grab_aligned_s(int x, int y, int width, int height,
                    int *image, int wsamp, int lsamp, short int mask = 0xff);

  void initregs();

protected:

  int map_color(Color colin);

public:

  IT_FG101 (int nc_in, int nr_in);
  IT_FG101 (int channel = 0,int camera = 0);     // initialize hardware
  ~IT_FG101();
  void close();
  char *device_info();

  // Grab functions.

  int grab(int *image, int x, int y, int width, int height,
	   float angle = 0.0, int sampw =1 , int samph =1,
	    short int mask = 0xff);

  void grab_constant_size (int *image, float x, float y,		  
			   int width, int height,
			   float angle = 0.0, short int mask = 0xff);

  // Acquiring a single line of pixels. 

  void linegrab(int x, int y, int length,int *image, float angle, 
		short int mask = 0xff);

  // Show an image on the IT_FG101 screen at the specified location
  // with the specified height and width.

  int show (int x, int y, int width, int height, int* image);

  // Draw and clear a graphic overlay on the IT_FG101 screen
  //   line:  endpoint and length
  //   line2:  two endpoints

  void line (float x, float y, int length,   // draw an overlayed line
	     float angle,
	     int color = GREEN_OVERLAY,int samp = 1);
  void clearline (float x, float y,	     // clear overlayed line
		  int length, float angle, int samp = 1);

  void line2 (float x1, float y1, float x2, float y2, 
	      int color = GREEN_OVERLAY);
  void clearline2 (float x1, float y1, float x2, float y2)

  void square (float x, float y, int r, int color = GREEN_OVERLAY);

  // Draw and clear a circle on the IT_FG101 screen

  void circle (float x, float y, int r, int color = GREEN_OVERLAY);
  void clearcircle(float x, float y,  int r);

  // Draw and clear a cubic-polynomial segment

  void cubic (float x, float y, int length, float angle,
	      float a, float b, float c, int color = GREEN_OVERLAY);
  void clearcubic (float x, float y, int length, float angle,
		   float a, float b, float c);

  // Some overlays for functions that do the appropriate memory
  // address switching before calling the function

//  void sclear (int value) {sethdw();::sclear(value);};
//  void snap (int waitflag) {sethdw();::snap(waitflag);};
  void setvmask(unsigned short mask);
  void setpmask(unsigned short mask);
  unsigned short getpmask();

};

// include inline functions
#include "IT_FG101.solaris.icc"

//-----------------------------------------------------------------------------
#endif
