/*                                                                -*-c++-*-
    Copyright (C) 1996-1997 Gregory D. Hager, Jonathan Wang (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  IMG_SEQ.hh
//
//  Declaration of the image sequence class.
//
//  06/09/96 Jonathan Wang, after code for K2T_V300_MONO by Kentaro Toyama
//  08/07/96 Greg Hager, total revamp
//  02/10/97 Kentaro Toyama, inline functions moved, comments added.
//
//-----------------------------------------------------------------------------

#ifndef IMG_SEQ_h
#define IMG_SEQ_h

#include <stdio.h>
#include "Tracker.hh"
#include "XWindow.hh"
#include "XConsole.hh"	// since IMG_SEQ doesn't have an overlay
#include "Image.hh"	// we need to have a window to display
#include "Video.hh"
#include "Tools.hh"

//-----------------------------------------------------------------------------
// Class : ImageSeqence_Mono
//
//* ImageSequence_Mono provides an interface between tracking software 
//* and pre-recorded image sequence.  Assumes a sequence of pgm images 
//* that are read in frame by frame under user control.
//*
//* The current implementation saves image sequence into a directory whose
//* name is the same as that of the image sequence.
//* One sequence is allowed per object instantiation.
//* Each image corresponds to a file whose name is "img" concatenated with
//* frame counter.
//* Image files are saved/retrieved via Image:read()/write(). 
//*
//* See comments in Video class for explanation of derived functions.
//* See also, Class MPEG.
//-----------------------------------------------------------------------------

class ImageSequence_Mono: public MonoVideo {

  Image vimage;
  char *name;
  
  int frame_count; 
  int update_step;
  int auto_step_mode;       // Whether to just increment with each grab
  
  XConsole con;
  XWindow *win;	

protected:

  int map_color(Color colin);

  // Unique to ImageSequence

  //* Protected function that constructs file names.  It assumes the user 
  //* supplies a format string with a single %d directive for the image number.
  void construct_name(char *buff);

  //* Reads image from file.
  int get_image();
  
public:

  //* Member : ImageSequence_Mono::ImageSequenceMono
  //*
  //* ImageSequence_Mono constructor.
  //* Arguments are sequence name (char*), the first image number (int), 
  //* and the number of grabs per image before the next image is utilized
  //* (int).  The last argument is 0 for the special case of using static 
  //* images, or manual updates.  
  ImageSequence_Mono (char *base_name, int first_image = 0,
		      int update_step=1);
  ~ImageSequence_Mono();
  void close();

  char *device_info();

  // Set it up so the default video interfaces work

  virtual int pre_grab();
  virtual void *current_frame_ptr();

  //* Grab an image, but do not forward the sequence (i.e., grab the same 
  //* image again, in absence of explicit command to do otherwise).
  int grab_static(int *im, int x, int y, int width, int height,
	    float angle = 0.0, int sampw =1 , int samph =1,
	    short int mask = 0xff);
    
  //* Set auto_step_mode, which forces forwarding of the sequence after
  //* bval numger of calls to grab.  
  int auto_step(int bval);

  //* This loads an image and forces the sequence forward by one step.
  //* Should be called explicitly in the event that update_step is 0.
  int forward();
  
  // Show an image on the ImageSequence_Mono screen at the specified location
  // with the specified height and width.

  int show (int x, int y, int width, int height, int *image);

  // Draw and clear a graphic overlay on the ImageSequence_Mono screen
  //   line:  endpoint and length
  //   line2:  two endpoints

  void point (int x, int y, Color color = 1, int size=1);
 
  void line (float x, float y, int length,   // draw an overlayed line
	     float angle,
	     int color = 1,int samp = 1);
  void clearline (float x, float y,	     // clear overlayed line
		  int length, float angle, int samp = 1);

  // Draw and clear a circle on the ImageSequence_Mono screen

  void circle (float x, float y, int r, int color = 1);
  void clearcircle(float x, float y,  int r);

  // Draw and clear a cubic-polynomial segment

  void cubic (float x, float y, int length, float angle,
	      float a, float b, float c, int color = 1);
  void clearcubic (float x, float y, int length, float angle,
		   float a, float b, float c);

};

// include inline functions
#include "IMG_SEQ.icc"

//-----------------------------------------------------------------------------
#endif
