/*                                                                -*-c++-*-
    Copyright (C) 1996-1997 Gregory D. Hager, Jonathan Wang (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  IMG_SEQ.cc
//
//  Definition of image sequence class member functions.
//
//  06/09/96 Jonathan Wang, after code for IMG_SEQ by Kentaro Toyama
//  08/07/96 Greg Hager, total revamp
//  02/10/97 Kentaro Toyama, comments added.
//
//-----------------------------------------------------------------------------

#include <fcntl.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <stdlib.h>
#include <sys/file.h>
#include <unistd.h>
#ifdef __GNUC__
#include <string.h>
#else
#include <strings.h>
#endif

#include "Video.hh"
#include "Acquire.hh"
#include "IMG_SEQ.hh"

//-----------------------------------------------------------------------------
//  Constructor and destructor
//-----------------------------------------------------------------------------

ImageSequence_Mono::ImageSequence_Mono (char *dir_name, int first_image, 
					int update_step_in) 
: MonoVideo(4)
{

  // initializations
  
  auto_step_mode = 1;
  update_step = update_step_in;
  frame_count = first_image;
  
  name=dir_name;
  win=new XWindow(con);
  
  // This gets the first image into vimage
  
  forward();
  
  // Use this to set size
  
  set_size(vimage.height(),vimage.width());
  
  tracker_cleanup (this);
}

void 
ImageSequence_Mono::close() 
{
}

//-----------------------------------------------------------------------------
//  Grab functions
//-----------------------------------------------------------------------------

int 
ImageSequence_Mono::forward() 
{
  char lname[200];

  if (!get_image()) {
    cout << "Failed to get image at step " << frame_count <<endl;
    return 0;
  }
   
  // Update the display
  construct_name(lname);
  win->show(vimage,lname);
  frame_count+=update_step;
  
  return 1;

}


//-----------------------------------------------------------------------------
//  Display functions
//-----------------------------------------------------------------------------

int 
ImageSequence_Mono::show (int x, int y,int width, int height, int *im) 
{
  if (!(in_view(x,y,width,height)))
    return 0;
  
  XVImage<int> image(ncols, nrows, im); 	// will worry about size later
  //   image.image=im;
  
  win->show((Image)image);
  
  return 1;
}

//--------------------- For Drawing Pretty Pictures ------------

void 
ImageSequence_Mono::point (int x, int y, Color color, int size) 
{
  // !!! Needed?
}

void 
ImageSequence_Mono::line (float x, float y, int length, float angle,
			  Color color, int samp) 
{
  win->line(int(x), int(y), length, angle, color);
}

void 
ImageSequence_Mono::circle (float x, float y, int r, Color color) 
{
  // !!! Needs to be written.
}

void 
ImageSequence_Mono::cubic (float x, float y, int length, float angle,
			   float a, float b, float c, Color color)
{
  // !!! Needs to be written.
}

//-----------------------------------------------------------------------------

