/*                                                                -*-c++-*-
    Copyright (C) 1993-1997 Gregory D. Hager and Sidd Puri (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  Galileo.hh
//
//  Specification of the Galileo class, which provides an interface between
//  tracking software and Galileo hardware.
//
//  06/06/93 Sidd Puri
//  07/06/94 Greg Hager
//
//-----------------------------------------------------------------------------

#ifndef Galileo_h
#define Galileo_h

extern "C" {
#include <vl/vl.h>
}

#define GALILEO_DEVICE_NUMBER  1
#define MYJUMP 20

#include "Video.hh"

//-----------------------------------------------------------------------------
//  Galileo class declaration
//
//* See comments in Video class for explanation of derived functions.
//*
//* All Galileo monitor routines deal with graphics on the user terminal,
//* via the gl library.
//-----------------------------------------------------------------------------

class Galileo : public Video {
  
  static VLServer svr;
  static int switchvar;
  static int ninstances;
  
  int source;
  static ulong *lbuf[2];
  
  static VLPath path;
  static VLNode src, drn;
    static VLBuffer buffer;
  static long win[2];
  
  //* Transfer a new image to memory, if a new image has been grabbed by
  //* the framegrabber.
  // !!! Is this the right comment?
  VLInfoPtr checknew();
  
public:
  
  Galileo (int camera = 0, int zoom_in = 1);
  ~Galileo();
  void cleanup();
  
  char *device_info();
  
  // Acquire a rectangle of data at an angle.

  int grab(int *image, int x, int y, int width, int height,
	   float angle = 0.0, int sampw =1 , int samph =1,
	   short int mask = 0xff);
  
  int show (int x, int y, int width, int height, int* image);
  
  void line (float x, float y, int length, float angle,
	     int color = default_color,int samp = 1);
  void clearline (float x, float y,
		  int length, float angle, int samp = 1);
  
  void line2 (float x1, float y1, float x2, float y2, 
	      int color = default_color);
  void clearline2 (float x1, float y1, float x2, float y2);
  
  // Draw and clear a circle on the Galileo screen
  
  void circle (float x, float y, int r, int color = default_color);
  void clearcircle(float x, float y,  int r);
  
  // Draw and clear a cubic-polynomial segment
  
  void cubic (float x, float y, int length, float angle,
	      float a, float b, float c, int color = default_color);
  void clearcubic (float x, float y, int length, float angle,
		   float a, float b, float c);
  
  
};

// include inline functions
#include "Galileo.icc"

#endif
