/*                                                                -*-c++-*-
    Copyright (C) 1996-1997 Gregory D. Hager (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  Devices.hh
//
//  06/??/96 Greg Hager
//
//  This file is here primarily to make it possible to write "device
//  independent" programs.
//
//-----------------------------------------------------------------------------


#include <site_config.h>

// These two are always included

#include "MPEG.hh"
#include "IMG_SEQ.hh"

// These are all hardware dependent

#ifdef USE_INDYCAM_MONO 
#include "IndyCam_Mono.hh"
#endif

#ifdef USE_INDYCAM_COLOR
#include "IndyCam_Color.hh"
#endif

#ifdef  GALILEO_MONO
#include "Galileo_Mono.hh"
#endif

#ifdef  USE_K2T_MONO
#include "K2T_V300_Mono.hh"
#endif

#ifdef  USE_K2T_COLOR 
#include "K2T_V300_Color.hh"
#endif

#ifdef  IT_FG101_MONO_SUNOS
#include "IT_FG101.hh"
#endif

#ifdef  IT_FG101_MONO_SOLARIS
#include "IT_FG101.hh"
#endif

#ifdef  USE_IT_ICPCI
#include "IT_icpci.hh"
#endif

#ifdef  USE_DT3155
#include "DT3155.hh"
#endif

#ifdef USE_RTVC
#include "RTVC.hh"
#endif

#ifdef USE_METEOR
#include  "Meteor.hh"
#endif

#ifdef USE_BT848
#include  "BT848.hh"
#endif

#ifdef USE_IEEE1394
#include "Ieee1394.hh"
#endif
