/*                                                                -*-c++-*-
    Copyright (C) 1996-1997 Gregory D. Hager, Kentaro Toyama (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  DeviceTools.cc
//
//  04/??/96 Kentaro Toyama 
//
//  Used by some classes which require bounding envelope computation.
//  This file will usually be included in a .cc file.
// !!! Function(s) defined here should probably be inline or come with a
// !!!   header file.
//
//-----------------------------------------------------------------------------

#include <math.h>
#include "Tools.hh"

static
void 
aligned_envelope (int width, int height, float o,
		  int *new_width, int *new_height)
{
  double c = fabs(cos(o));
  double s = fabs(sin(o));
  
  *new_width = round((c*width+s*height)/max2(fabs(s),fabs(c)));
  *new_height = round((s*width+c*height)/max2(fabs(s),fabs(c)));
}
