/*                                                                -*-c++-*-
    Copyright (C) 1994-1997 Gregory D. Hager (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  DT3155.hh
//
//  Specification of the DT3155 class, which provides an interface between
//  tracking software and DT3155 hardware.
//
//  07/06/94 Greg Hager
//  02/10/97 Kentaro Toyama, comments added.
//
//-----------------------------------------------------------------------------

#ifndef DT3155_h
#define DT3155_h

extern "C" {
#include <dt3155.h>
#include <dt3155_lib.h>
}

#include "Video.hh"

//-----------------------------------------------------------------------------
//   Class : DT3155 
//
//*  The class allows access to any of the RGB channels, or a luminance
//*  value computed from them.  The type of information is specified when
//*  the variable is created.  Multiple instances of this class can be
//*  created.  They all share a common window, but can access different
//*  fields of the image.
//*
//*  This class can probably be improved in speed by constructing a more
//*  direct connection between the framegrabber and the monitor.  Also
//*  this class uses frames in a nonstandard way: a data pointer to 
//*  released frames is maintained although the frame is again in use
//*  by the framegrabber.
//*
//*  Many Video base class functions are left undefined.  
//-----------------------------------------------------------------------------

class DT3155 : public MonoVideo 
{
  
  dt3155_info_t *fb_info;
  
  int gotfirst;
  
  short int maskval;
  
  u_char *checknew();
  u_char *dataPtr;
  
  void error_exit(char *mess = NULL);
  
  int map_color(int x);

public:
  
  DT3155 (int nonblocking = 0);
  ~DT3155(); 
  
  // Device information
  
  char *device_info();
  void close();
  
  // We allow the DT3155 to be directly address bypassing the
  // usual "grab" routines if desired.
  
  int bytesperpixel();
  virtual void *direct_memptr();
  virtual int  bytesperpixel() const;
  
  virtual int pre_grab();

  // Just return the current image
  
  virtual void *current_frame_ptr();
    
  int grab_aligned (int *image, float &x, float  &y, int width, int height,
		    int sampw, int samph, short int mask);
    
  // No display capabilities
  
  virtual int show (int x, int y, int width, int height, int* image;
  
  virtual void line (float x, float y, int length, float angle,
		     Color color = default_color,int samp = 1);
  
};

#include "DT3155.icc"

#endif
