/*                                                                -*-c++-*-
    Copyright (C) 1994-1997 Gregory D. Hager (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  DT3155.cc
//
//  Definition of DT3155 class member functions.
//
//  07/06/94 Greg Hager
//  02/10/97 Kentaro Toyama, comments added.
//
//-----------------------------------------------------------------------------

#include <site_config.h>
#ifdef  USE_DT3155

#include <stdlib.h>
#include "Video.hh"
#include "Acquire.hh"
#include "DT3155.hh"

void
DT3155::error_exit(char *mess) 
{
  if (mess != NULL) 
    cerr << mess << endl;
  else
    cerr << "Some problem with the DT3155 setup" << endl;
  exit(1);
}

DT3155::DT3155(int nonblocking) : 
MonoVideo(1,640,480) 
{
  
  // find board and get it open 
  
  if ((fb_info = dt3155_open(FORMAT_NTSC,nonblocking) ) == NULL)
    error_exit("dt3155_open failed");
  
  // initialize hardware 
  
  if (!dt3155Init(fb_info))
    error_exit("dt3155_init failed");
  
  // Begin the data transfer 
  
  if (!dt3155Acquire_intr(fb_info,DT3155_START)) {
    error_exit("start acquisition failed");
  }
  
  _is_mappable = 1;
  
}

void 
DT3155::close() 
{
  
  if (!dt3155Acquire_intr(fb_info,DT3155_STOP)) {
    printf ("Help me, I've started and I can't get stopped\n");
  }
  dt3155_close(fb_info);
  
}


u_char*
DT3155::checknew()
{
  dt3155_read_t r;
  char *newdataPtr = dt3155NextFrame(fb_info,&r);
  
  if (newdataPtr != NULL) {
    dataPtr = newdataPtr;
  }		
  
  return dataPtr;
}

int 
DT3155::pre_grab() 
{
  
  checknew();
  
  if (!gotfirst) {
    while (dataPtr == NULL)
      checknew();
    gotfirst = 1;
  }
  
  if (dataPtr == NULL)
    return 0;
  else
    return 1;
}

int
DT3155::grab_aligned (int *image, float &x, float  &y,
		      int width, int height,
		      int sampw, int samph, short int mask) 
{
  int i,j;
  int fx,fy;
  int rskip;
  register unsigned char *ldata, *endldata, *finalldata;
  
  if (!pre_grab())
    return 0;
  
  if (!(in_view(x,y,width*sampw,height*samph)))
    return 0;
  
  fx = adjust_to_first_coord(x,width*sampw);
  fy = adjust_to_first_coord(y,height*samph);
  
  width *=sampw;
  rskip  = samph*ncols;
  
  ldata = (unsigned char *)dataPtr + fy*ncols+fx;
  finalldata = ldata + rskip*height + width;
  rskip -= width;
  for(;ldata<finalldata;ldata += rskip) {
    for(endldata = ldata+width;ldata< endldata;ldata+=sampw)
      *image++ = *ldata;
  }
}

#endif // USE_DT3155
