//-----------------------------------------------------------------------------
//
//  Meteor.h
//
//  Specification of the Meteor class, which provides an interface between
//  tracking software and Matrox Meteor hardware.
//
//  7.1.1997
//  Jouni Aro <jaro@iki.fi>
//
//  Written based on DT3155.h by Greg Hager
//  and Linux meteor driver by Jim Bray
//  (original version by Mark Tinguely and Jim Lowe)
//
//  Uses a meteor driver installed as a linux kernel module.  Grabbing
//  is done using continuous frame capture to memory mapped area.
//
//  Both monochrome and colour signals are used, though I have used
//  only monochrome, so you may need to make changes to the code if
//  you need colour.
//
//  You will need the BT848 driver from:
//  	??
//-----------------------------------------------------------------------------

#ifndef BT848_h
#define BT848_h

//  Define PAL or SECAM if your input is not from NTSC (default)
//  (preferably in the makefile)

#include <asm/types.h>
#include <videodev.h>
#include "Video.hh"

#define NTSC
//#define PIXEL 

#if defined(PAL)
#define MAXROWS 576
#define MAXCOLS 768
#define DEFAULT_FORMAT VIDEO_MODE_PAL
#define MAXFPS 25
#elif defined(SECAM)
#define MAXROWS 576
#define MAXCOLS 768
#define DEFAULT_FORMAT VIDEO_MODE_SECAM
#define MAXFPS 25
#else /* NTSC */
#define MAXROWS 480
#define MAXCOLS 640
#define DEFAULT_FORMAT VIDEO_MODE_NTSC
#define MAXFPS 30
#endif

#define NOFRAMES 1
#define MAXPIXELSIZE 4
#define MAXSIZE (NOFRAMES*MAXPIXELSIZE*MAXROWS*MAXCOLS)

extern int newframecaptured;/* this sucker can be used to poll for newimages
			       by settiing equal to 0 and then looking for 
			       when it goes to 1 */

//-----------------------------------------------------------------------------
//  BT848 class declaration
//-----------------------------------------------------------------------------
class BT848 : public ColorVideo 
{

  int fd;				// file descriptor

  struct video_capability  capability;
  struct video_picture     pict;
  struct video_channel *channels;

  unsigned char            *map;
  struct video_mmap        gb;

  int count;

  pid_t child;

  void error_exit(char *mess = NULL);
  int map_color(int x) {return 1;};

  int mmap();
  void grabber();

  char* dataPtr;

public:

  // Define the number of bytes if you use colour signals
  BT848 (int nbytes=1, int cols=MAXCOLS, int rows=MAXROWS,
	  char *input_dev = "/dev/video0");

  // Device information

  int grab_input(int, int);

  char *device_info(){return "BrookTree 848 Capture card";};

  void close();
  int start();
  int stop();
  int resize(int cols, int rows);

  // We allow the BT848 to be directly address bypassing the
  // usual "grab" routines if desired.

  virtual void *direct_memptr() { return (_is_mappable) ? 
				    current_frame_ptr() : NULL;};
  virtual int  bytesperpixel()  const {return _bytesperpixel;};

  // Nothing to be done

  virtual int pre_grab() { return 1; };

  // Just return the current image

  virtual void *current_frame_ptr() { pre_grab(); return dataPtr; };

  // No display capabilities

  virtual int show (int x, int y,
		    int width, int height,	     // show image 
		    int *image) {return 0;};

  virtual void line (float x, float y, int length, float angle,
		     Color color = default_color,int samp = 1) {};



};

#endif
